/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metadata.runtime.impl;

import java.util.List;
import org.teiid.designer.metadata.runtime.TransformationRecord;
import org.teiid.designer.metadata.runtime.impl.AbstractMetadataRecord;
import org.teiid.designer.metadata.runtime.impl.MetadataRecordDelegate;

public class TransformationRecordImpl
extends AbstractMetadataRecord
implements TransformationRecord {
    private static final long serialVersionUID = 1L;
    private String transformation;
    private Object transformedObjectID;
    private String transformationType;
    private List bindings;
    private List schemaPaths;

    public TransformationRecordImpl() {
        this(new MetadataRecordDelegate());
    }

    protected TransformationRecordImpl(MetadataRecordDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getTransformation() {
        return this.transformation;
    }

    @Override
    public List getBindings() {
        return this.bindings;
    }

    @Override
    public List getSchemaPaths() {
        return this.schemaPaths;
    }

    @Override
    public String getTransformationType() {
        return this.transformationType;
    }

    @Override
    public Object getTransformedObjectID() {
        return this.transformedObjectID;
    }

    @Override
    public String getType() {
        return this.getTransformTypeForRecordType(this.getRecordType());
    }

    public void setTransformation(String string) {
        this.transformation = string;
    }

    public void setTransformedObjectID(Object object) {
        this.transformedObjectID = object;
    }

    public void setTransformationType(String string) {
        this.transformationType = string;
    }

    public void setBindings(List bindings) {
        this.bindings = bindings;
    }

    public void setSchemaPaths(List collection) {
        this.schemaPaths = collection;
    }

    protected String getTransformTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'P': {
                return "Select";
            }
            case 'Q': {
                return "Insert";
            }
            case 'R': {
                return "Update";
            }
            case 'S': {
                return "Delete";
            }
            case 'T': {
                return "Procedure";
            }
            case 'U': {
                return "Mapping";
            }
        }
        throw new IllegalArgumentException("Invalid record type, for key " + recordType);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append(this.getClass().getSimpleName());
        sb.append(" name=");
        sb.append(this.getName());
        sb.append(", nameInSource=");
        sb.append(this.getNameInSource());
        sb.append(", uuid=");
        sb.append(this.getUUID());
        sb.append(", pathInModel=");
        sb.append(this.getPath());
        return sb.toString();
    }
}

