/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.RelationalPlugin;

public class DatatypeProcessor {
    public static final String DATATYPE_STRING = "string";
    public static final String DATATYPE_VARCHAR = "varchar";
    public static final String DATATYPE_CHAR = "char";
    public static final String DATATYPE_BOOLEAN = "boolean";
    public static final String DATATYPE_BYTE = "byte";
    public static final String DATATYPE_TINYINT = "tinyint";
    public static final String DATATYPE_SHORT = "short";
    public static final String DATATYPE_SMALLINT = "smallint";
    public static final String DATATYPE_INTEGER = "integer";
    public static final String DATATYPE_SERIAL = "serial";
    public static final String DATATYPE_LONG = "long";
    public static final String DATATYPE_BIGINT = "bigint";
    public static final String DATATYPE_BIGINTEGER = "biginteger";
    public static final String DATATYPE_FLOAT = "float";
    public static final String DATATYPE_REAL = "real";
    public static final String DATATYPE_DOUBLE = "double";
    public static final String DATATYPE_BIGDECIMAL = "bigdecimal";
    public static final String DATATYPE_DECIMAL = "decimal";
    public static final String DATATYPE_DATE = "date";
    public static final String DATATYPE_TIME = "time";
    public static final String DATATYPE_TIMESTAMP = "timestamp";
    public static final String DATATYPE_OBJECT = "object";
    public static final String DATATYPE_BLOB = "blob";
    public static final String DATATYPE_CLOB = "clob";
    public static final String DATATYPE_XML = "xml";
    public static final String DATATYPE_INT = "int";
    public static final String DEFAULT_DATATYPE = "string";
    public static final int DEFAULT_DATATYPE_LENGTH = 0;
    private DatatypeManager datatypeManager = ModelerCore.getWorkspaceDatatypeManager();
    private EObject objectDatatype;

    public EObject findDatatype(String identifier) {
        String convertedTypeName = identifier;
        if (DATATYPE_SERIAL.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_INTEGER;
        } else if (DATATYPE_VARCHAR.equalsIgnoreCase(identifier)) {
            convertedTypeName = "string";
        } else if (DATATYPE_TINYINT.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_BYTE;
        } else if (DATATYPE_SMALLINT.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_SHORT;
        } else if (DATATYPE_BIGINT.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_LONG;
        } else if (DATATYPE_REAL.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_FLOAT;
        } else if (DATATYPE_XML.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_OBJECT;
        } else if (DATATYPE_INTEGER.equalsIgnoreCase(identifier)) {
            convertedTypeName = DATATYPE_INT;
        }
        EObject result = null;
        try {
            result = this.datatypeManager.getBuiltInDatatype(convertedTypeName);
            if (result == null) {
                result = this.datatypeManager.findDatatype(convertedTypeName);
            }
        }
        catch (ModelerCoreException modelerCoreException) {
            RelationalPlugin.Util.log(2, NLS.bind((String)Messages.datatypeProcessor_error_finding_datatatype, (Object)convertedTypeName));
            result = this.getObjectDatatype();
        }
        return result;
    }

    private EObject getObjectDatatype() {
        if (this.objectDatatype == null) {
            try {
                this.objectDatatype = this.datatypeManager.getBuiltInDatatype(DATATYPE_OBJECT);
            }
            catch (ModelerCoreException modelerCoreException) {
                RelationalPlugin.Util.log(2, NLS.bind((String)Messages.datatypeProcessor_error_finding_datatatype, (Object)DATATYPE_OBJECT));
            }
        }
        return this.objectDatatype;
    }
}

