/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalColumn;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;

public class RelationalForeignKey
extends RelationalReference {
    public static final String KEY_FOREIGN_KEY_MULTIPLICITY = "FKMULTIPLICITY";
    public static final String KEY_PRIMARY_KEY_MULTIPLICITY = "PKMULTIPLICITY";
    public static final String KEY_UNIQUE_KEY_NAME = "UNIQUEKEYNAME";
    public static final String KEY_UNIQUE_KEY_TABLE_NAME = "UNIQUEKEYTABLENAME";
    public static final String DEFAULT_FOREIGN_KEY_MULTIPLICITY = "ZERO_TO_MANY";
    public static final String DEFAULT_PRIMARY_KEY_MULTIPLICITY = "ONE";
    public static final String DEFAULT_UNIQUE_KEY_NAME = null;
    public static final String DEFAULT_UNIQUE_KEY_TABLE_NAME = null;
    public static final boolean DEFAULT_ALLOW_JOIN = true;
    private Collection<RelationalColumn> columns;
    private String foreignKeyMultiplicity;
    private String primaryKeyMultiplicity;
    private String uniqueKeyName;
    private String uniqueKeyTableName;
    private boolean allowJoin = true;

    public RelationalForeignKey() {
        this.setType(9);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalForeignKey(String name) {
        super(name);
        this.setType(9);
        this.columns = new ArrayList<RelationalColumn>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    @Override
    public RelationalForeignKey clone() {
        RelationalForeignKey clonedFK = new RelationalForeignKey(this.getName());
        clonedFK.setNameInSource(this.getNameInSource());
        clonedFK.setDescription(this.getDescription());
        clonedFK.setForeignKeyMultiplicity(this.getForeignKeyMultiplicity());
        clonedFK.setPrimaryKeyMultiplicity(this.getPrimaryKeyMultiplicity());
        clonedFK.setUniqueKeyName(this.getUniqueKeyName());
        clonedFK.setUniqueKeyTableName(this.getUniqueKeyTableName());
        clonedFK.setModelType(this.getModelType());
        clonedFK.setAllowJoin(this.isAllowJoin());
        for (RelationalColumn col : this.getColumns()) {
            clonedFK.addColumn(col);
        }
        return clonedFK;
    }

    @Override
    public void inject(RelationalReference originalFK) {
        super.inject(originalFK);
        RelationalForeignKey theFK = (RelationalForeignKey)originalFK;
        this.setName(theFK.getName());
        this.setNameInSource(theFK.getNameInSource());
        this.setDescription(theFK.getDescription());
        this.setForeignKeyMultiplicity(theFK.getForeignKeyMultiplicity());
        this.setPrimaryKeyMultiplicity(theFK.getPrimaryKeyMultiplicity());
        this.setUniqueKeyName(theFK.getUniqueKeyName());
        this.setUniqueKeyTableName(theFK.getUniqueKeyTableName());
        this.setModelType(theFK.getModelType());
        this.getColumns().clear();
        for (RelationalColumn col : theFK.getColumns()) {
            this.addColumn(col);
        }
    }

    public Collection<RelationalColumn> getColumns() {
        return this.columns;
    }

    public void addColumn(RelationalColumn column) {
        this.columns.add(column);
    }

    public String getForeignKeyMultiplicity() {
        return this.foreignKeyMultiplicity;
    }

    public void setForeignKeyMultiplicity(String foreignKeyMultiplicity) {
        if (foreignKeyMultiplicity == null || this.foreignKeyMultiplicity == null || !this.foreignKeyMultiplicity.equals(foreignKeyMultiplicity)) {
            this.foreignKeyMultiplicity = foreignKeyMultiplicity;
            this.handleInfoChanged();
        }
    }

    public String getPrimaryKeyMultiplicity() {
        return this.primaryKeyMultiplicity;
    }

    public void setPrimaryKeyMultiplicity(String primaryKeyMultiplicity) {
        if (primaryKeyMultiplicity == null || this.primaryKeyMultiplicity == null || !this.primaryKeyMultiplicity.equals(primaryKeyMultiplicity)) {
            this.primaryKeyMultiplicity = primaryKeyMultiplicity;
            this.handleInfoChanged();
        }
    }

    public String getUniqueKeyName() {
        return this.uniqueKeyName;
    }

    public void setUniqueKeyName(String uniqueKeyName) {
        if (uniqueKeyName == null || this.uniqueKeyName == null || !this.uniqueKeyName.equals(uniqueKeyName)) {
            this.uniqueKeyName = uniqueKeyName;
            this.handleInfoChanged();
        }
    }

    public String getUniqueKeyTableName() {
        return this.uniqueKeyTableName;
    }

    public void setUniqueKeyTableName(String uniqueKeyTableName) {
        if (uniqueKeyTableName == null || this.uniqueKeyTableName == null || !this.uniqueKeyTableName.equals(uniqueKeyTableName)) {
            this.uniqueKeyTableName = uniqueKeyTableName;
            this.handleInfoChanged();
        }
    }

    public RelationalTable getTable() {
        if (this.getParent() != null) {
            return (RelationalTable)this.getParent();
        }
        return null;
    }

    public boolean isAllowJoin() {
        return this.allowJoin;
    }

    public void setAllowJoin(boolean allowJoin) {
        if (this.allowJoin != allowJoin) {
            this.allowJoin = allowJoin;
            this.handleInfoChanged();
        }
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_FOREIGN_KEY_MULTIPLICITY)) {
                this.setForeignKeyMultiplicity(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_PRIMARY_KEY_MULTIPLICITY)) {
                this.setPrimaryKeyMultiplicity(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_UNIQUE_KEY_NAME)) {
                this.setUniqueKeyName(value);
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_UNIQUE_KEY_TABLE_NAME)) continue;
            this.setUniqueKeyTableName(value);
        }
    }

    @Override
    public void handleInfoChanged() {
        super.handleInfoChanged();
        if (!this.allowJoin) {
            this.getExtensionProperties().put("allow-join", Boolean.toString(this.isAllowJoin()));
        } else {
            this.getExtensionProperties().remove("allow-join");
        }
    }

    @Override
    public void validate() {
        super.validate();
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.getColumns().isEmpty()) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_fkNoColumnsDefined, (Object)this.getName())));
            return;
        }
        if (this.getUniqueKeyName() == null || this.getUniqueKeyName().length() == 0) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", NLS.bind((String)Messages.validate_error_fKUniqueKeyNameIsUndefined, (Object)this.getName())));
            return;
        }
        if (this.getUniqueKeyTableName() == null || this.getUniqueKeyTableName().length() == 0) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_error_fKReferencedUniqueKeyTableIsUndefined));
            return;
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        if (!this.getColumns().isEmpty()) {
            sb.append("\n\t").append(this.getColumns().size()).append(" columns");
            for (RelationalColumn col : this.getColumns()) {
                sb.append("\n\tcol = ").append(col);
            }
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalForeignKey other = (RelationalForeignKey)object;
        if (!(CoreStringUtil.valuesAreEqual((String)this.getForeignKeyMultiplicity(), (String)other.getForeignKeyMultiplicity()) && CoreStringUtil.valuesAreEqual((String)this.getPrimaryKeyMultiplicity(), (String)other.getPrimaryKeyMultiplicity()) && CoreStringUtil.valuesAreEqual((String)this.getUniqueKeyName(), (String)other.getUniqueKeyName()) && CoreStringUtil.valuesAreEqual((String)this.getUniqueKeyTableName(), (String)other.getUniqueKeyTableName()))) {
            return false;
        }
        Collection<RelationalColumn> thisColumns = this.getColumns();
        Collection<RelationalColumn> thatColumns = other.getColumns();
        if (thisColumns.size() != thatColumns.size()) {
            return false;
        }
        return thisColumns.isEmpty() || thisColumns.containsAll(thatColumns);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getForeignKeyMultiplicity())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getForeignKeyMultiplicity()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getPrimaryKeyMultiplicity())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getPrimaryKeyMultiplicity()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getUniqueKeyName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getUniqueKeyName()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getUniqueKeyTableName())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getUniqueKeyTableName()});
        }
        Collection<RelationalColumn> cols = this.getColumns();
        for (RelationalColumn col : cols) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{col});
        }
        return result;
    }
}

