/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.Messages;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;

public class RelationalParameter
extends RelationalReference {
    public static final String KEY_DATATYPE = "DATATYPE";
    public static final String KEY_NATIVE_TYPE = "NATIVETYPE";
    public static final String KEY_NULLABLE = "NULLABLE";
    public static final String KEY_DIRECTION = "DIRECTION";
    public static final String KEY_DEFAULT_VALUE = "DEFAULTVALUE";
    public static final String KEY_LENGTH = "LENGTH";
    public static final String KEY_PRECISION = "PRECISION";
    public static final String KEY_RADIX = "RADIX";
    public static final String KEY_SCALE = "SCALE";
    public static final String DEFAULT_DATATYPE = null;
    public static final String DEFAULT_NATIVE_TYPE = null;
    public static final String DEFAULT_NULLABLE = "NULLABLE";
    public static final String DEFAULT_DIRECTION = "IN";
    public static final String DEFAULT_DEFAULT_VALUE = null;
    public static final int DEFAULT_LENGTH = 0;
    public static final int DEFAULT_PRECISION = 0;
    public static final int DEFAULT_RADIX = 0;
    public static final int DEFAULT_SCALE = 10;
    public static final int DEFAULT_STRING_LENGTH = 4000;
    private String datatype;
    private String nativeType;
    private String nullable;
    private String direction = "IN";
    private String defaultValue;
    private int length;
    private int precision;
    private int radix;
    private int scale;

    public RelationalParameter() {
        this.setType(6);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalParameter(String name) {
        super(name);
        this.setType(6);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public void setNativeType(String nativeType) {
        this.nativeType = nativeType;
    }

    public String getNullable() {
        return this.nullable;
    }

    public void setNullable(String nullable) {
        this.nullable = nullable;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    public int getRadix() {
        return this.radix;
    }

    public void setRadix(int radix) {
        this.radix = radix;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() == 4) {
            return;
        }
        RelationalProcedure parentProcedure = (RelationalProcedure)this.getParent();
        if (parentProcedure != null && parentProcedure.isFunction() && !this.getDirection().equalsIgnoreCase(DEFAULT_DIRECTION) && !this.getDirection().equalsIgnoreCase("RETURN")) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.relational", Messages.validate_error_invalidParameterDirectionInFunction));
            return;
        }
    }

    public void setProperties(Properties props) {
        for (Object key : props.keySet()) {
            String keyStr = (String)key;
            String value = props.getProperty(keyStr);
            if (value != null && value.length() == 0) continue;
            if (keyStr.equalsIgnoreCase("NAME")) {
                this.setName(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NAMEINSOURCE")) {
                this.setNameInSource(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("DESCRIPTION")) {
                this.setDescription(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_LENGTH)) {
                this.setLength(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DATATYPE)) {
                this.setDatatype(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DEFAULT_VALUE)) {
                this.setDefaultValue(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_DIRECTION)) {
                this.setDirection(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_NATIVE_TYPE)) {
                this.setNativeType(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase("NULLABLE")) {
                this.setNullable(value);
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_PRECISION)) {
                this.setPrecision(Integer.parseInt(value));
                continue;
            }
            if (keyStr.equalsIgnoreCase(KEY_SCALE)) {
                this.setScale(Integer.parseInt(value));
                continue;
            }
            if (!keyStr.equalsIgnoreCase(KEY_RADIX)) continue;
            this.setRadix(Integer.parseInt(value));
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalParameter other = (RelationalParameter)object;
        if (!(CoreStringUtil.valuesAreEqual((String)this.getDatatype(), (String)other.getDatatype()) && CoreStringUtil.valuesAreEqual((String)this.getDefaultValue(), (String)other.getDefaultValue()) && CoreStringUtil.valuesAreEqual((String)this.getDirection(), (String)other.getDirection()) && CoreStringUtil.valuesAreEqual((String)this.getNativeType(), (String)other.getNativeType()) && CoreStringUtil.valuesAreEqual((String)this.getNullable(), (String)other.getNullable()))) {
            return false;
        }
        return this.getLength() == other.getLength() && this.getPrecision() == other.getPrecision() && this.getRadix() == other.getRadix() && this.getScale() == other.getScale();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        if (!CoreStringUtil.isEmpty((String)this.getDatatype())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDatatype()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getDefaultValue())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDefaultValue()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getDirection())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getDirection()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getNativeType())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNativeType()});
        }
        if (!CoreStringUtil.isEmpty((String)this.getNullable())) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{this.getNullable()});
        }
        result = HashCodeUtil.hashCode((int)result, (int)this.getLength());
        result = HashCodeUtil.hashCode((int)result, (int)this.getPrecision());
        result = HashCodeUtil.hashCode((int)result, (int)this.getRadix());
        result = HashCodeUtil.hashCode((int)result, (int)this.getScale());
        return result;
    }
}

