/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.relational.model;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.designer.HashCodeUtil;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.relational.model.RelationalIndex;
import org.teiid.designer.relational.model.RelationalProcedure;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.relational.model.RelationalTable;

public class RelationalSchema
extends RelationalReference {
    private List<RelationalIndex> indexes;
    private List<RelationalProcedure> procedures;
    private List<RelationalTable> tables;

    public RelationalSchema() {
        this.setType(1);
        this.indexes = new ArrayList<RelationalIndex>();
        this.procedures = new ArrayList<RelationalProcedure>();
        this.tables = new ArrayList<RelationalTable>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public RelationalSchema(String name) {
        super(name);
        this.setType(1);
        this.indexes = new ArrayList<RelationalIndex>();
        this.procedures = new ArrayList<RelationalProcedure>();
        this.tables = new ArrayList<RelationalTable>();
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public List<RelationalIndex> getIndexes() {
        return this.indexes;
    }

    public void addIndex(RelationalIndex index) {
        if (this.indexes.add(index)) {
            index.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeIndex(RelationalIndex index) {
        if (this.indexes.remove(index)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public List<RelationalProcedure> getProcedures() {
        return this.procedures;
    }

    public void addProcedure(RelationalProcedure procedure) {
        if (this.procedures.add(procedure)) {
            procedure.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeProcedure(RelationalProcedure procedure) {
        if (this.procedures.remove(procedure)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    public List<RelationalTable> getTables() {
        return this.tables;
    }

    public void addTable(RelationalTable table) {
        if (this.tables.add(table)) {
            table.setParent(this);
            this.handleInfoChanged();
        }
    }

    public boolean removeTable(RelationalTable table) {
        if (this.tables.remove(table)) {
            this.handleInfoChanged();
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append(" : name = ").append(this.getName());
        return sb.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RelationalSchema other = (RelationalSchema)object;
        List<RelationalTable> thisTables = this.getTables();
        List<RelationalTable> thatTables = other.getTables();
        if (thisTables.size() != thatTables.size()) {
            return false;
        }
        if (!thisTables.isEmpty() && !thisTables.containsAll(thatTables)) {
            return false;
        }
        List<RelationalProcedure> thisProcedures = this.getProcedures();
        List<RelationalProcedure> thatProcedures = other.getProcedures();
        if (thisProcedures.size() != thatProcedures.size()) {
            return false;
        }
        if (!thisProcedures.isEmpty() && !thisProcedures.containsAll(thatProcedures)) {
            return false;
        }
        List<RelationalIndex> thisIndexes = this.getIndexes();
        List<RelationalIndex> thatIndexes = other.getIndexes();
        if (thisIndexes.size() != thatIndexes.size()) {
            return false;
        }
        return thisIndexes.isEmpty() || thisIndexes.containsAll(thatIndexes);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        List<RelationalTable> tables = this.getTables();
        for (RelationalTable table : tables) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{table});
        }
        List<RelationalProcedure> procs = this.getProcedures();
        for (RelationalProcedure proc : procs) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{proc});
        }
        List<RelationalIndex> indexes = this.getIndexes();
        for (RelationalIndex index : indexes) {
            result = HashCodeUtil.hashCode((int)result, (Object[])new Object[]{index});
        }
        return result;
    }
}

