/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.esb.validator;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.text.ITextSourceReference;
import org.jboss.tools.common.validation.ContextValidationHelper;
import org.jboss.tools.common.validation.IPreferenceInfo;
import org.jboss.tools.common.validation.IProjectValidationContext;
import org.jboss.tools.common.validation.IValidatingProjectSet;
import org.jboss.tools.common.validation.IValidatingProjectTree;
import org.jboss.tools.common.validation.PreferenceInfoManager;
import org.jboss.tools.common.validation.ValidatorManager;
import org.jboss.tools.common.validation.internal.ProjectValidationContext;
import org.jboss.tools.common.validation.internal.SimpleValidatingProjectTree;
import org.jboss.tools.common.validation.internal.ValidatingProjectSet;
import org.jboss.tools.esb.core.facet.IJBossESBFacetDataModelProperties;
import org.jboss.tools.esb.core.model.impl.BusinessRulesProcessor;
import org.jboss.tools.esb.validator.ESBPreferences;
import org.jboss.tools.esb.validator.ESBValidationErrorManager;
import org.jboss.tools.esb.validator.ESBValidatorMessages;
import org.jboss.tools.esb.validator.ESBValidatorPlugin;
import org.jboss.tools.esb.validator.XMLValueInfo;

public class ESBCoreValidator
extends ESBValidationErrorManager
implements org.jboss.tools.common.validation.IValidator {
    public static final String ID = "org.jboss.tools.esb.validator.ESBCoreValidator";
    public static final String PREFERENCE_PAGE_ID = "org.jboss.tools.esb.validator.ui.ESBValidatorPreferencePage";
    public static final String PROPERTY_PAGE_ID = "org.jboss.tools.esb.validator.ui.propertyPages.ESBValidatorPreferencePage";
    static String XML_EXT = ".xml";
    static String ATTR_PATH = "path";
    static String ATTR_ATTRIBUTE = "attribute";
    String projectName;
    Map<IProject, IProjectValidationContext> contexts = new HashMap<IProject, IProjectValidationContext>();
    static String ATTR_RULE_LANGUAGE = "rule language";
    static String ATTR_RULE_SET = "rule set";
    static String ATTR_RULE_AUDIT_INTERVAL = "rule audit interval";
    static String ATTR_RULE_AUDIT_TYPE = "rule audit type";
    static String ATTR_ESB = "esb";
    static Set<String> OBJECT_PATH_LOCATIONS = new HashSet<String>();

    static {
        OBJECT_PATH_LOCATIONS.add("body");
        OBJECT_PATH_LOCATIONS.add("header");
        OBJECT_PATH_LOCATIONS.add("properties");
        OBJECT_PATH_LOCATIONS.add("attachment");
    }

    public String getId() {
        return ID;
    }

    public String getBuilderId() {
        return null;
    }

    public IValidatingProjectTree getValidatingProjects(IProject project) {
        IProjectValidationContext rootContext = this.contexts.get(project);
        if (rootContext == null) {
            rootContext = new ProjectValidationContext();
            this.contexts.put(project, rootContext);
        }
        HashSet<IProject> projects = new HashSet<IProject>();
        projects.add(project);
        ValidatingProjectSet projectSet = new ValidatingProjectSet(project, projects, rootContext);
        return new SimpleValidatingProjectTree((IValidatingProjectSet)projectSet);
    }

    public boolean shouldValidate(IProject project) {
        block7: {
            if (!project.isAccessible()) {
                return false;
            }
            String esbContentFolder = null;
            try {
                esbContentFolder = project.getPersistentProperty(IJBossESBFacetDataModelProperties.QNAME_ESB_CONTENT_FOLDER);
            }
            catch (CoreException coreException) {}
            if (esbContentFolder != null) {
                return this.isEnabled(project);
            }
            try {
                IFacetedProject fp = ProjectFacetsManager.create((IProject)project);
                IProjectFacet f = ProjectFacetsManager.getProjectFacet((String)"jst.jboss.esb");
                if (fp == null || f == null || fp.getInstalledVersion(f) == null) break block7;
                return true;
            }
            catch (CoreException e) {
                ESBValidatorPlugin.log((Exception)((Object)e));
                return false;
            }
        }
        return project.hasNature("org.jboss.tools.esb.project.ESBNature") && this.isEnabled(project);
    }

    public void init(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, IValidator manager, IReporter reporter) {
        super.init(project, validationHelper, context, manager, reporter);
        this.projectName = project.getName();
    }

    public IStatus validate(Set<IFile> changedFiles, IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        for (IFile file : changedFiles) {
            XModelObject o;
            if (!file.getName().endsWith(XML_EXT) || (o = EclipseResourceUtil.createObjectForResource((IResource)file)) == null || !o.getModelEntity().getName().startsWith("FileESB")) continue;
            this.validateESBConfigFile(o, file);
        }
        return this.OK_STATUS;
    }

    private void validateESBConfigFile(XModelObject object, IFile file) {
        this.validateChannelIDRefs(object, file);
        this.validateScheduleIDRefs(object, file);
        this.validateActions(object, file);
    }

    public IStatus validateAll(IProject project, ContextValidationHelper validationHelper, IProjectValidationContext context, ValidatorManager manager, IReporter reporter) throws ValidationException {
        this.init(project, validationHelper, context, (IValidator)manager, reporter);
        this.displaySubtask(ESBValidatorMessages.VALIDATING_PROJECT, new String[]{this.projectName});
        String esbContentFolder = null;
        IFolder esbContent = null;
        try {
            esbContentFolder = project.getPersistentProperty(IJBossESBFacetDataModelProperties.QNAME_ESB_CONTENT_FOLDER);
            if (esbContentFolder == null) {
                esbContentFolder = "esbcontent";
            }
            if ((esbContent = project.getFolder((IPath)new Path(String.valueOf(esbContentFolder) + "/META-INF"))).isAccessible()) {
                IResource[] rs;
                IResource[] iResourceArray = rs = esbContent.members();
                int n = rs.length;
                int n2 = 0;
                while (n2 < n) {
                    XModelObject o;
                    IFile file;
                    String name;
                    IResource r = iResourceArray[n2];
                    if (r instanceof IFile && (name = (file = (IFile)r).getName()).endsWith(XML_EXT) && (o = EclipseResourceUtil.createObjectForResource((IResource)file)) != null && o.getModelEntity().getName().startsWith("FileESB")) {
                        this.validateESBConfigFile(o, file);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            return new Status(4, "org.jboss.tools.esb.validator", MessageFormat.format("Validation error for project {0}", project.getLocation().toString()), (Throwable)e);
        }
        return this.OK_STATUS;
    }

    void validateChannelIDRefs(XModelObject object, IFile file) {
        XModelObject[] services;
        XModelObject servicesFolder = object.getChildByPath("Services");
        if (servicesFolder == null) {
            return;
        }
        Map<String, String> ids = this.getAllChannelRefIDs(object);
        XModelObject[] xModelObjectArray = services = servicesFolder.getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject[] listeners;
            XModelObject service = xModelObjectArray[n2];
            XModelObject listenersFolder = service.getChildByPath("Listeners");
            XModelObject[] xModelObjectArray2 = listeners = listenersFolder.getChildren();
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                XModelObject listener = xModelObjectArray2[n4];
                String channelIDRef = listener.getAttributeValue("channel id ref");
                if (channelIDRef != null) {
                    String entity = ids.get(channelIDRef);
                    if (channelIDRef.length() != 0) {
                        if (entity == null) {
                            IMarker marker = this.addError(ESBValidatorMessages.LISTENER_REFERENCES_NON_EXISTENT_CHANNEL, ESBPreferences.LISTENER_REFERENCES_NON_EXISTENT_CHANNEL, this.getSourceReference(listener, "channel id ref"), (IResource)file);
                            if (marker != null) {
                                try {
                                    marker.setAttribute(ATTR_PATH, (Object)listener.getPath());
                                    marker.setAttribute(ATTR_ATTRIBUTE, (Object)"channel id ref");
                                }
                                catch (CoreException e) {
                                    e.printStackTrace();
                                }
                            }
                        } else {
                            String busEntityPrefix = this.getBusEntityPrefix(listener.getModelEntity().getName());
                            if (busEntityPrefix != null && !entity.startsWith(busEntityPrefix)) {
                                IMarker marker = this.addError(ESBValidatorMessages.LISTENER_REFERENCES_INCOMPATIBLE_CHANNEL, ESBPreferences.LISTENER_REFERENCES_INCOMPATIBLE_CHANNEL, this.getSourceReference(listener, "channel id ref"), (IResource)file);
                                this.bindMarkerToPathAndAttribute(marker, listener, "channel id ref");
                            }
                        }
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private String getBusEntityPrefix(String listenerEntity) {
        if (listenerEntity == null) {
            return null;
        }
        if (listenerEntity.startsWith("ESBListener")) {
            return null;
        }
        if (listenerEntity.startsWith("ESBJCAGateway")) {
            return "ESBJMSBus";
        }
        int i = listenerEntity.indexOf("Listener");
        if (i < 0) {
            return null;
        }
        return String.valueOf(listenerEntity.substring(0, i)) + "Bus";
    }

    private Map<String, String> getAllChannelRefIDs(XModelObject object) {
        HashMap<String, String> result = new HashMap<String, String>();
        XModelObject[] ps = object.getChildByPath("Providers").getChildren();
        int i = 0;
        while (i < ps.length) {
            XModelObject[] cs = ps[i].getChildren();
            int j = 0;
            while (j < cs.length) {
                String v;
                if (cs[j].getModelEntity().getAttribute("id") != null && (v = cs[j].getAttributeValue("id")) != null && v.length() > 0) {
                    result.put(v, cs[j].getModelEntity().getName());
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    void validateScheduleIDRefs(XModelObject object, IFile file) {
        XModelObject[] services;
        XModelObject servicesFolder = object.getChildByPath("Services");
        if (servicesFolder == null) {
            return;
        }
        Set<String> ids = this.getAllScheduleRefIDs(object);
        XModelObject[] xModelObjectArray = services = servicesFolder.getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject[] listeners;
            XModelObject service = xModelObjectArray[n2];
            XModelObject listenersFolder = service.getChildByPath("Listeners");
            XModelObject[] xModelObjectArray2 = listeners = listenersFolder.getChildren();
            int n3 = listeners.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarker marker;
                XModelObject listener = xModelObjectArray2[n4];
                String scheduleIDRef = listener.getAttributeValue("schedule id ref");
                if (scheduleIDRef != null && scheduleIDRef.length() != 0 && !ids.contains(scheduleIDRef) && (marker = this.addError(ESBValidatorMessages.LISTENER_REFERENCES_NON_EXISTENT_SCHEDULE, ESBPreferences.LISTENER_REFERENCES_NON_EXISTENT_SCHEDULE, this.getSourceReference(listener, "schedule id ref"), (IResource)file)) != null) {
                    try {
                        marker.setAttribute(ATTR_PATH, (Object)listener.getPath());
                        marker.setAttribute(ATTR_ATTRIBUTE, (Object)"schedule id ref");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private Set<String> getAllScheduleRefIDs(XModelObject object) {
        HashSet<String> result = new HashSet<String>();
        XModelObject[] ps = object.getChildByPath("Providers").getChildren();
        int i = 0;
        while (i < ps.length) {
            XModelObject[] cs = ps[i].getChildren();
            int j = 0;
            while (j < cs.length) {
                String v;
                if (cs[j].getModelEntity().getAttribute("schedule id") != null && (v = cs[j].getAttributeValue("schedule id")) != null && v.length() > 0) {
                    result.add(v);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    ITextSourceReference getSourceReference(XModelObject o, String attr) {
        return new XMLValueInfo(o, attr);
    }

    public boolean isEnabled(IProject project) {
        return ESBPreferences.isValidationEnabled(project);
    }

    void validateActions(XModelObject object, IFile file) {
        XModelObject[] services;
        XModelObject servicesFolder = object.getChildByPath("Services");
        if (servicesFolder == null) {
            return;
        }
        XModelObject[] xModelObjectArray = services = servicesFolder.getChildren();
        int n = services.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject[] actions;
            XModelObject service = xModelObjectArray[n2];
            XModelObject actionsFolder = service.getChildByPath("Actions");
            XModelObject[] xModelObjectArray2 = actions = actionsFolder.getChildren();
            int n3 = actions.length;
            int n4 = 0;
            while (n4 < n3) {
                XModelObject action = xModelObjectArray2[n4];
                String entity = action.getModelEntity().getName();
                if (entity.startsWith("ESBPreActionBusinessRulesProcessor")) {
                    this.validateBusinessRulesProcessor(action, file);
                }
                ++n4;
            }
            ++n2;
        }
    }

    void validateBusinessRulesProcessor(XModelObject object, IFile file) {
        XModelObject[] ps;
        String auditAuditType;
        String auditInterval;
        String lang = object.getAttributeValue(ATTR_RULE_LANGUAGE);
        if (lang != null && lang.length() > 0) {
            IMarker marker;
            String ruleSet = object.getAttributeValue(ATTR_RULE_SET);
            if (ruleSet == null || ruleSet.length() == 0) {
                marker = this.addError(ESBValidatorMessages.INVALID_RULE_SET_FOR_RULE_LANGUAGE, ESBPreferences.BUSINESS_RULES_PROCESSOR_PROBLEMS, this.getSourceReference(object, ATTR_RULE_LANGUAGE), (IResource)file);
                this.bindMarkerToPathAndAttribute(marker, object, ATTR_RULE_LANGUAGE);
            } else if (!ruleSet.endsWith(".dslr")) {
                marker = this.addError(ESBValidatorMessages.INVALID_RULE_SET_FOR_RULE_LANGUAGE, ESBPreferences.BUSINESS_RULES_PROCESSOR_PROBLEMS, this.getSourceReference(object, ATTR_RULE_SET), (IResource)file);
                this.bindMarkerToPathAndAttribute(marker, object, ATTR_RULE_SET);
            }
        }
        if ((auditInterval = object.getAttributeValue(ATTR_RULE_AUDIT_INTERVAL)) != null && auditInterval.length() > 0 && !"THREADED_FILE".equals(auditAuditType = object.getAttributeValue(ATTR_RULE_AUDIT_TYPE))) {
            IMarker marker = this.addError(ESBValidatorMessages.INVALID_RULE_AUDIT_TYPE_AND_INTERVAL, ESBPreferences.BUSINESS_RULES_PROCESSOR_PROBLEMS, this.getSourceReference(object, ATTR_RULE_AUDIT_INTERVAL), (IResource)file);
            this.bindMarkerToPathAndAttribute(marker, object, ATTR_RULE_AUDIT_INTERVAL);
        }
        XModelObject[] xModelObjectArray = ps = object.getChildren("ESBPreObjectPath");
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            XModelObject path = xModelObjectArray[n2];
            this.validateObjectPathForBusinessRulesProcessor(path, object, file);
            ++n2;
        }
        String ruleMultithreadEvaluation = object.getAttributeValue(BusinessRulesProcessor.ATTR_RULE_MULTITHREAD_EVALUATION);
        String ruleMaxThreads = object.getAttributeValue(BusinessRulesProcessor.ATTR_RULE_MAX_THREADS);
        if (!"true".equals(ruleMultithreadEvaluation) && ruleMaxThreads != null && ruleMaxThreads.length() > 0) {
            IMarker marker = this.addError(ESBValidatorMessages.INVALID_RULE_MAX_THREADS, ESBPreferences.BUSINESS_RULES_PROCESSOR_PROBLEMS, this.getSourceReference(object, BusinessRulesProcessor.ATTR_RULE_MAX_THREADS), (IResource)file);
            this.bindMarkerToPathAndAttribute(marker, object, BusinessRulesProcessor.ATTR_RULE_MAX_THREADS);
        }
    }

    void validateObjectPathForBusinessRulesProcessor(XModelObject path, XModelObject brp, IFile file) {
        String esb = path.getAttributeValue(ATTR_ESB);
        StringTokenizer st = new StringTokenizer(esb, ".");
        if (!st.hasMoreTokens()) {
            return;
        }
        String location = st.nextToken();
        if (!OBJECT_PATH_LOCATIONS.contains(location)) {
            IMarker marker = this.addError(ESBValidatorMessages.INVALID_OBJECT_PATH_WRONG_LOCATION, ESBPreferences.BUSINESS_RULES_PROCESSOR_PROBLEMS, this.getSourceReference(path, ATTR_ESB), (IResource)file);
            this.bindMarkerToPathAndAttribute(marker, path, ATTR_ESB);
        }
    }

    void bindMarkerToPathAndAttribute(IMarker marker, XModelObject object, String attr) {
        if (marker != null) {
            try {
                marker.setAttribute(ATTR_PATH, (Object)object.getPath());
                marker.setAttribute(ATTR_ATTRIBUTE, (Object)attr);
            }
            catch (CoreException e) {
                ESBValidatorPlugin.log((Exception)((Object)e));
            }
        }
    }

    public void registerPreferenceInfo() {
        PreferenceInfoManager.register((String)this.getProblemType(), (IPreferenceInfo)new ESBPreferenceInfo());
    }

    class ESBPreferenceInfo
    implements IPreferenceInfo {
        ESBPreferenceInfo() {
        }

        public String getPreferencePageId() {
            return ESBCoreValidator.PREFERENCE_PAGE_ID;
        }

        public String getPropertyPageId() {
            return ESBCoreValidator.PROPERTY_PAGE_ID;
        }

        public String getPluginId() {
            return "org.jboss.tools.esb.core";
        }
    }
}

