/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ddl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImportMessages {
    private String parseErrorMessage;
    private String parserId;
    private boolean hasParseError = false;
    private int parseErrorLineNumber = -1;
    private int parseErrorColNumber = -1;
    private int parseErrorIndex = -1;
    private List<String> progressMessages;
    private Map<String, Integer> unhandledTypeCountMap;

    public void clear() {
        this.parseErrorMessage = null;
        this.parserId = null;
        this.hasParseError = false;
        this.parseErrorLineNumber = -1;
        this.parseErrorColNumber = -1;
        this.parseErrorIndex = -1;
        this.progressMessages = null;
        this.unhandledTypeCountMap = null;
    }

    public void addProgressMessage(String message) {
        if (this.progressMessages == null) {
            this.progressMessages = new ArrayList<String>();
        }
        this.progressMessages.add(message);
    }

    public List<String> getProgressMessages() {
        if (this.progressMessages == null) {
            this.progressMessages = new ArrayList<String>();
        }
        return this.progressMessages;
    }

    public List<String> getUnhandledTypeMessages() {
        ArrayList<String> unhandledTypeMessages = new ArrayList<String>();
        if (this.unhandledTypeCountMap == null) {
            return new ArrayList<String>();
        }
        for (String typeStr : this.unhandledTypeCountMap.keySet()) {
            Integer typeCount = this.unhandledTypeCountMap.get(typeStr);
            String message = typeCount + " instances of a DDL statement of type [" + typeStr + "] were found, but cannot be processed";
            unhandledTypeMessages.add(message);
        }
        return unhandledTypeMessages;
    }

    public List<String> getAllMessages() {
        ArrayList<String> allMessages = new ArrayList<String>(this.getProgressMessages());
        allMessages.addAll(this.getUnhandledTypeMessages());
        return allMessages;
    }

    public void incrementUnhandledNodeType(String typeStr) {
        if (this.unhandledTypeCountMap == null) {
            this.unhandledTypeCountMap = new HashMap<String, Integer>();
        }
        if (this.unhandledTypeCountMap.containsKey(typeStr)) {
            Integer count = this.unhandledTypeCountMap.get(typeStr);
            count = count + 1;
            this.unhandledTypeCountMap.put(typeStr, count);
        } else {
            this.unhandledTypeCountMap.put(typeStr, new Integer(1));
        }
    }

    public void setParseErrorMessage(String message) {
        this.parseErrorMessage = message;
    }

    public String getParseErrorMessage() {
        return this.parseErrorMessage;
    }

    public boolean hasParseError() {
        return this.hasParseError;
    }

    public void setHasParseError(boolean hasParseError) {
        this.hasParseError = hasParseError;
    }

    public int getParseErrorLineNumber() {
        return this.parseErrorLineNumber;
    }

    public void setParseErrorLineNumber(int lineNumber) {
        this.parseErrorLineNumber = lineNumber;
    }

    public int getParseErrorColNumber() {
        return this.parseErrorColNumber;
    }

    public void setParseErrorColNumber(int colNumber) {
        this.parseErrorColNumber = colNumber;
    }

    public String getParserId() {
        return this.parserId;
    }

    public void setParserId(String parserId) {
        this.parserId = parserId;
    }

    public int getParseErrorIndex() {
        return this.parseErrorIndex;
    }

    public void setParseErrorIndex(int index) {
        this.parseErrorIndex = index;
    }
}

