/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.datatools.ui.flatfile;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.SortedMap;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.oda.flatfile.InvalidResourceException;
import org.eclipse.datatools.connectivity.oda.flatfile.ResourceLocator;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards.MenuButton;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards.RelativeFileSelectionDialog;
import org.eclipse.datatools.connectivity.ui.PingJob;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.teiid.designer.datatools.ui.flatfile.Messages;

public class ReplacementFolderSelectionPageHelper {
    private static final String PREFIX = "org.eclipse.datatools.oda.cshelp.";
    private static final String CONTEXT_ID_DATASOURCE_FLATFILE = "org.eclipse.datatools.oda.cshelp.Wizard_FlatfileDatasource_ID";
    private WizardPage wizardPage;
    private PreferencePage propertyPage;
    private org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers ri;
    private transient Text folderLocation = null;
    private transient Text fileURI = null;
    private transient MenuButton browseLocalFileButton = null;
    private transient Button typeLineCheckBox = null;
    private transient Button browseFolderButton = null;
    private transient Combo charSetSelectionCombo = null;
    private transient Button columnNameLineCheckBox = null;
    private transient Combo flatFileStyleCombo = null;
    private transient Button trailNullColsCheckBox = null;
    private transient Composite parent = null;
    private transient Button homeFolderChoice = null;
    private transient Button homeFolderCheckBox = null;
    private transient Button fileURIChoice = null;
    private static final String[] fileExtensions = new String[]{"*.csv", "*.psv", "*.ssv", "*.tsv", "*.txt", "*.*"};
    private static final String[] flatFileStyles = new String[]{org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.flatfileComma"), org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.flatfileSemicolon"), org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.flatfilePipe"), org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.flatfileTab")};
    private SortedMap<String, Charset> charSetMap;
    static final String DEFAULT_MESSAGE = org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"FolderSelectionPageHelper.SelectFolderDialog.Title");
    private static final int CORRECT_FOLDER = 0;
    private static final int ERROR_INVALID_PATH = 1;
    private static final String EMPTY_STRING = "";
    private static final Integer SELECT_RELATIVE_PATH = 1;
    private static final Integer SELECT_ABSOLUTE_PATH = 2;
    private boolean needsCheckURITest = true;
    private String URIValue = "";

    ReplacementFolderSelectionPageHelper(WizardPage page) {
        this.wizardPage = page;
    }

    ReplacementFolderSelectionPageHelper(PreferencePage page) {
        this.propertyPage = page;
    }

    void createCustomControl(Composite parent) {
        this.parent = parent;
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        content.setLayout((Layout)layout);
        this.setupFolderLocation(content);
        this.setupFileURI(content);
        this.setupCharset(content);
        this.setupFlatfileStyleList(content);
        this.setupColumnNameLineCheckBox(content);
        this.setupTypeLineCheckBox(content);
        this.setupTrailNullsCheckBox(content);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), CONTEXT_ID_DATASOURCE_FLATFILE);
    }

    String getFolderLocation() {
        if (this.folderLocation == null) {
            return EMPTY_STRING;
        }
        return this.getFolderLocationString();
    }

    String getFileURI() {
        if (this.fileURI == null) {
            return EMPTY_STRING;
        }
        return this.getFileURIString();
    }

    String getWhetherUseFirstLineAsColumnNameLine() {
        if (this.columnNameLineCheckBox == null || !this.columnNameLineCheckBox.getEnabled()) {
            return EMPTY_STRING;
        }
        return this.columnNameLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getWhetherUseSecondLineAsTypeLine() {
        if (this.typeLineCheckBox == null) {
            return EMPTY_STRING;
        }
        return this.typeLineCheckBox.getSelection() ? "YES" : "NO";
    }

    String getWhetherUseTrailNulls() {
        if (this.trailNullColsCheckBox == null) {
            return EMPTY_STRING;
        }
        return this.trailNullColsCheckBox.getSelection() ? "YES" : "NO";
    }

    String getCharSet() {
        if (this.charSetSelectionCombo == null) {
            return EMPTY_STRING;
        }
        return this.charSetSelectionCombo.getItem(this.charSetSelectionCombo.getSelectionIndex());
    }

    Properties collectCustomProperties(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        if (this.homeFolderChoice.getSelection()) {
            props.setProperty("HOME", this.getFolderLocation().trim());
            props.remove("URI");
        }
        if (this.fileURIChoice.getSelection()) {
            props.setProperty("URI", this.getFileURI());
            props.remove("HOME");
        }
        props.setProperty("DELIMTYPE", this.getFlatfileStyle());
        props.setProperty("INCLCOLUMNNAME", this.getWhetherUseFirstLineAsColumnNameLine());
        props.setProperty("INCLTYPELINE", this.getWhetherUseSecondLineAsTypeLine());
        props.setProperty("CHARSET", this.getCharSet());
        props.setProperty("TRAILNULLCOLS", this.getWhetherUseTrailNulls());
        return props;
    }

    void initCustomControl(Properties profileProps) {
        String fileURI;
        if (profileProps == null || profileProps.isEmpty() || this.folderLocation == null || this.fileURI == null) {
            return;
        }
        String folderPath = profileProps.getProperty("HOME");
        if (folderPath != null && folderPath.length() != 0) {
            this.setFolderLocationString(folderPath);
            this.switchFileSelectionMode(true);
        }
        if ((fileURI = profileProps.getProperty("URI")) != null && fileURI.length() != 0) {
            this.setFileURIString(fileURI);
            this.switchFileSelectionMode(false);
        }
        String delimiterType = profileProps.getProperty("DELIMTYPE");
        this.initFlatfileSytleSelection(delimiterType);
        String hasColumnNameLine = profileProps.getProperty("INCLCOLUMNNAME");
        if (hasColumnNameLine == null) {
            hasColumnNameLine = "YES";
        }
        if (hasColumnNameLine.equalsIgnoreCase("YES")) {
            this.columnNameLineCheckBox.setSelection(true);
            String useSecondLine = profileProps.getProperty("INCLTYPELINE");
            if (useSecondLine == null) {
                useSecondLine = EMPTY_STRING;
            }
            this.typeLineCheckBox.setEnabled(true);
            this.typeLineCheckBox.setSelection(useSecondLine.equalsIgnoreCase("YES"));
        } else {
            this.columnNameLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setEnabled(false);
        }
        String trailNullCols = profileProps.getProperty("TRAILNULLCOLS");
        if (trailNullCols == null) {
            trailNullCols = "NO";
        }
        if (trailNullCols.equalsIgnoreCase("YES")) {
            this.trailNullColsCheckBox.setSelection(true);
        } else {
            this.trailNullColsCheckBox.setSelection(false);
        }
        String charSet = profileProps.getProperty("CHARSET");
        if (charSet == null || charSet.trim().length() == 0) {
            this.charSetSelectionCombo.select(0);
        } else {
            this.charSetSelectionCombo.select(this.charSetSelectionCombo.indexOf(charSet));
        }
    }

    private String getFlatfileStyle() {
        String value = this.flatFileStyleCombo.getText();
        if (value.equals(flatFileStyles[0])) {
            return "COMMA";
        }
        if (value.equals(flatFileStyles[1])) {
            return "SEMICOLON";
        }
        if (value.equals(flatFileStyles[2])) {
            return "PIPE";
        }
        if (value.equals(flatFileStyles[3])) {
            return "TAB";
        }
        return "COMMA";
    }

    private void setFolderLocationString(String folderPath) {
        this.folderLocation.setText(TextProcessorWrapper.process((String)folderPath));
    }

    private void setFileURIString(String file) {
        file = this.convertRelativePath(file);
        this.fileURI.setText(TextProcessorWrapper.process((String)file));
    }

    private String convertRelativePath(String file) {
        String path = file;
        if (file != null && file.length() > 0) {
            try {
                new URI(file);
            }
            catch (URISyntaxException uRISyntaxException) {
                try {
                    URI uri = new URI(file.replace('\\', '/'));
                    if (!uri.isAbsolute()) {
                        path = uri.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException2) {}
            }
        }
        return path;
    }

    private String getFolderLocationString() {
        return TextProcessorWrapper.deprocess((String)this.folderLocation.getText());
    }

    private String getFileURIString() {
        return TextProcessorWrapper.deprocess((String)this.convertRelativePath(this.fileURI.getText()));
    }

    private void initFlatfileSytleSelection(String delimiterType) {
        if ("COMMA".equals(delimiterType)) {
            this.flatFileStyleCombo.select(0);
        } else if ("SEMICOLON".equals(delimiterType)) {
            this.flatFileStyleCombo.select(1);
        } else if ("PIPE".equals(delimiterType)) {
            this.flatFileStyleCombo.select(2);
        } else if ("TAB".equals(delimiterType)) {
            this.flatFileStyleCombo.select(3);
        }
    }

    private void setupFolderLocation(Composite composite) {
        this.homeFolderChoice = new Button(composite, 16);
        this.homeFolderChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReplacementFolderSelectionPageHelper.this.switchFileSelectionMode(true);
                ReplacementFolderSelectionPageHelper.this.validatePageStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.homeFolderChoice.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.selectFolder"));
        GridData data = new GridData(768);
        this.folderLocation = new Text(composite, 2048);
        this.folderLocation.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.folderLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ReplacementFolderSelectionPageHelper.this.validatePageStatus();
            }
        });
        this.browseFolderButton = new Button(composite, 0);
        this.browseFolderButton.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"button.selectFolder.browse"));
        this.browseFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(ReplacementFolderSelectionPageHelper.this.folderLocation.getShell());
                String folderLocationValue = ReplacementFolderSelectionPageHelper.this.getFolderLocationString();
                if (folderLocationValue != null && folderLocationValue.trim().length() > 0) {
                    dialog.setFilterPath(folderLocationValue);
                }
                dialog.setMessage(DEFAULT_MESSAGE);
                String selectedLocation = dialog.open();
                if (selectedLocation != null) {
                    ReplacementFolderSelectionPageHelper.this.setFolderLocationString(selectedLocation);
                }
            }
        });
        this.homeFolderCheckBox = new Button(composite, 32);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.homeFolderCheckBox);
        this.homeFolderCheckBox.setText(org.teiid.datatools.connectivity.ui.Messages.getString((String)"homeFolderCheckboxText"));
        this.homeFolderCheckBox.setToolTipText(org.teiid.datatools.connectivity.ui.Messages.getString((String)"homeFolderCheckboxTooltip"));
        this.homeFolderCheckBox.setSelection(true);
        this.homeFolderCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplacementFolderSelectionPageHelper.this.validatePageStatus();
            }
        });
        new Label(composite, 0);
    }

    private void setupFileURI(Composite composite) {
        MenuItem item;
        this.fileURIChoice = new Button(composite, 16);
        this.fileURIChoice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ReplacementFolderSelectionPageHelper.this.switchFileSelectionMode(false);
                ReplacementFolderSelectionPageHelper.this.needsCheckURITest = true;
                ReplacementFolderSelectionPageHelper.this.validatePageStatus();
                ReplacementFolderSelectionPageHelper.this.needsCheckURITest = false;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fileURIChoice.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.fileURI"));
        GridData data = new GridData(768);
        this.fileURI = new Text(composite, 2048);
        this.fileURI.setLayoutData((Object)data);
        this.setPageComplete(false);
        this.fileURI.setToolTipText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"lable.fileURI.tooltip"));
        this.fileURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!ReplacementFolderSelectionPageHelper.this.fileURI.getText().trim().equals(ReplacementFolderSelectionPageHelper.this.URIValue)) {
                    ReplacementFolderSelectionPageHelper.this.needsCheckURITest = true;
                    ReplacementFolderSelectionPageHelper.this.validatePageStatus();
                    ReplacementFolderSelectionPageHelper.this.needsCheckURITest = false;
                    ReplacementFolderSelectionPageHelper.this.URIValue = ReplacementFolderSelectionPageHelper.this.fileURI.getText().trim();
                }
            }
        });
        this.browseLocalFileButton = new MenuButton(composite, 0);
        this.browseLocalFileButton.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"button.selectFileURI.browse"));
        this.browseLocalFileButton.setToolTipText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"button.selectFileURI.browse.tooltips"));
        Menu menu = new Menu((Decorations)composite.getShell(), 8);
        SelectionAdapter action = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget instanceof MenuItem) {
                    MenuItem item = (MenuItem)e.widget;
                    Integer type = (Integer)item.getData();
                    ReplacementFolderSelectionPageHelper.this.handleFileSelection(type);
                } else if (e.widget instanceof MenuButton) {
                    if (ReplacementFolderSelectionPageHelper.this.ri != null) {
                        ReplacementFolderSelectionPageHelper.this.handleFileSelection(SELECT_RELATIVE_PATH);
                    } else {
                        ReplacementFolderSelectionPageHelper.this.handleFileSelection(SELECT_ABSOLUTE_PATH);
                    }
                }
            }
        };
        if (this.ri != null) {
            item = new MenuItem(menu, 8);
            item.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"button.selectFileURI.menuItem.relativePath"));
            item.setData((Object)SELECT_RELATIVE_PATH);
            item.addSelectionListener((SelectionListener)action);
        }
        item = new MenuItem(menu, 8);
        item.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"button.selectFileURI.menuItem.absolutePath"));
        item.setData((Object)SELECT_ABSOLUTE_PATH);
        item.addSelectionListener((SelectionListener)action);
        this.browseLocalFileButton.setDropDownMenu(menu);
        this.browseLocalFileButton.addSelectionListener((SelectionListener)action);
        GridData btnData = new GridData();
        btnData.widthHint = this.browseLocalFileButton.computeSize((int)-1, (int)-1).x;
        this.browseLocalFileButton.setLayoutData((Object)btnData);
    }

    private void handleFileSelection(int selectionType) {
        if (selectionType == SELECT_RELATIVE_PATH) {
            RelativeFileSelectionDialog dialog = new RelativeFileSelectionDialog(this.fileURI.getShell(), new File(this.getResourceFolder()));
            if (dialog.open() == 0) {
                try {
                    URI uri = dialog.getSelectedURI();
                    if (uri != null) {
                        this.setFileURIString(uri.getPath());
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        } else if (selectionType == SELECT_ABSOLUTE_PATH) {
            FileDialog dialog = new FileDialog(this.fileURI.getShell());
            String path = this.getResourceFolder();
            if (path != null && path.trim().length() > 0) {
                dialog.setFilterPath(path);
            }
            dialog.setFilterExtensions(fileExtensions);
            String filePath = dialog.open();
            if (filePath != null) {
                this.setFileURIString(filePath);
            }
        }
    }

    private String getResourceFolder() {
        if (this.ri != null && this.ri.getApplResourceBaseURI() != null) {
            return new File(this.ri.getApplResourceBaseURI()).getAbsolutePath();
        }
        return null;
    }

    private void switchFileSelectionMode(boolean homeFolder) {
        this.folderLocation.setEnabled(homeFolder);
        this.browseFolderButton.setEnabled(homeFolder);
        this.homeFolderChoice.setSelection(homeFolder);
        this.homeFolderCheckBox.setSelection(homeFolder);
        this.fileURI.setEnabled(!homeFolder);
        this.browseLocalFileButton.setEnabled(!homeFolder);
        this.fileURIChoice.setSelection(!homeFolder);
    }

    private int verifyFileLocation() {
        try {
            return this.verifyFileLocation(true);
        }
        catch (InvalidResourceException invalidResourceException) {
            return 1;
        }
    }

    private void verfiyFileLocation() throws InvalidResourceException {
        this.verifyFileLocation(false);
        this.setMessage(DEFAULT_MESSAGE, 0);
    }

    private int verifyFileLocation(boolean supressException) throws InvalidResourceException {
        String folderLocationValue = this.getFolderLocationString().trim();
        String fileURIValue = this.getFileURIString().trim();
        folderLocationValue = folderLocationValue.length() > 0 ? folderLocationValue : null;
        fileURIValue = fileURIValue.length() > 0 ? fileURIValue : null;
        try {
            File locFile;
            if (this.fileURIChoice.getSelection()) {
                ResourceLocator.validateFileURI((String)fileURIValue, (org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers)this.ri);
            } else if (this.homeFolderChoice.getSelection() && this.homeFolderCheckBox.getSelection() && !(locFile = new File(folderLocationValue)).exists()) {
                throw new InvalidResourceException(1, org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"error.invalidFlatFilePath"));
            }
        }
        catch (InvalidResourceException ex) {
            this.setMessage(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"error.invalidFlatFilePath"), 3);
            this.setPageComplete(false);
            if (this.wizardPage == null) {
                this.setPageComplete(true);
                if (!supressException) {
                    throw ex;
                }
            }
            if (supressException) {
                return 1;
            }
            throw ex;
        }
        this.setPageComplete(true);
        this.setMessage(DEFAULT_MESSAGE, 0);
        return 0;
    }

    private void setupCharset(Composite composite) {
        Label labelCharSet = new Label(composite, 0);
        labelCharSet.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.selectCharset"));
        this.charSetSelectionCombo = new Combo(composite, 8);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.charSetSelectionCombo.setLayoutData((Object)data);
        this.charSetMap = Charset.availableCharsets();
        Object[] charSetsArray = this.charSetMap.keySet().toArray();
        int i = 0;
        while (i < charSetsArray.length) {
            String charSetName = ((Charset)this.charSetMap.get(charSetsArray[i])).name();
            this.charSetSelectionCombo.add(charSetName);
            if ("UTF-8".equalsIgnoreCase(charSetName)) {
                this.charSetSelectionCombo.select(i);
            }
            ++i;
        }
    }

    private void setupFlatfileStyleList(Composite composite) {
        Label labelCSVType = new Label(composite, 0);
        labelCSVType.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.selectFlatfileStyle"));
        this.flatFileStyleCombo = new Combo(composite, 8);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.flatFileStyleCombo.setLayoutData((Object)data);
        int i = 0;
        while (i < flatFileStyles.length) {
            this.flatFileStyleCombo.add(flatFileStyles[i]);
            ++i;
        }
        this.flatFileStyleCombo.select(0);
    }

    private void setupColumnNameLineCheckBox(Composite composite) {
        Label labelFill = new Label(composite, 0);
        labelFill.setText(EMPTY_STRING);
        this.columnNameLineCheckBox = new Button(composite, 32);
        this.columnNameLineCheckBox.setToolTipText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"tooltip.columnnameline"));
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.columnNameLineCheckBox.setLayoutData((Object)gd);
        this.columnNameLineCheckBox.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.includeColumnNameLine"));
        this.columnNameLineCheckBox.setSelection(true);
        this.columnNameLineCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReplacementFolderSelectionPageHelper.this.refreshTypeLineCheckBoxStatus();
            }
        });
    }

    private void setupTypeLineCheckBox(Composite composite) {
        this.typeLineCheckBox = new Button(composite, 32);
        this.typeLineCheckBox.setToolTipText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"tooltip.typeline"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.typeLineCheckBox.setLayoutData((Object)data);
        this.typeLineCheckBox.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.includeTypeLine"));
    }

    private void setupTrailNullsCheckBox(Composite composite) {
        this.trailNullColsCheckBox = new Button(composite, 32);
        this.trailNullColsCheckBox.setToolTipText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"tooltip.trailNull"));
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.trailNullColsCheckBox.setLayoutData((Object)data);
        this.trailNullColsCheckBox.setText(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"label.trailNull"));
        this.trailNullColsCheckBox.setSelection(false);
        this.trailNullColsCheckBox.setEnabled(true);
    }

    private void setPageComplete(boolean complete) {
        if (this.wizardPage != null) {
            this.wizardPage.setPageComplete(complete);
        } else if (this.propertyPage != null) {
            this.propertyPage.setValid(complete);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.wizardPage != null) {
            this.wizardPage.setMessage(newMessage, newType);
        } else if (this.propertyPage != null) {
            this.propertyPage.setMessage(newMessage, newType);
        }
    }

    private Control getControl() {
        if (this.wizardPage != null) {
            return this.wizardPage.getControl();
        }
        if (this.propertyPage != null) {
            return this.propertyPage.getControl();
        }
        return null;
    }

    public Runnable createTestConnectionRunnable(final IConnectionProfile profile) {
        return new Runnable(){

            @Override
            public void run() {
                IConnection conn = PingJob.createTestConnection((IConnectionProfile)profile);
                Throwable exception = PingJob.getTestConnectionException((IConnection)conn);
                if (exception == null) {
                    exception = this.testConnection();
                }
                PingJob.PingUIJob.showTestConnectionMessage((Shell)ReplacementFolderSelectionPageHelper.this.parent.getShell(), (Throwable)exception);
                if (conn != null) {
                    conn.close();
                }
            }

            private Throwable testConnection() {
                InvalidResourceException exception = null;
                try {
                    ReplacementFolderSelectionPageHelper.this.verfiyFileLocation();
                }
                catch (InvalidResourceException ex) {
                    exception = ex;
                }
                return exception;
            }
        };
    }

    public void setResourceIdentifiers(ResourceIdentifiers resourceIdentifiers) {
        if (resourceIdentifiers != null) {
            this.ri = DesignSessionUtil.createRuntimeResourceIdentifiers((ResourceIdentifiers)resourceIdentifiers);
        }
    }

    public void resetUIStatus() {
        if (this.getFileURI().length() > 0) {
            this.switchFileSelectionMode(false);
        } else {
            this.switchFileSelectionMode(true);
        }
    }

    protected void refreshTypeLineCheckBoxStatus() {
        if (this.columnNameLineCheckBox.getSelection()) {
            this.typeLineCheckBox.setEnabled(this.columnNameLineCheckBox.isEnabled());
        } else {
            this.typeLineCheckBox.setSelection(false);
            this.typeLineCheckBox.setEnabled(false);
        }
    }

    private void validatePageStatus() {
        int status = 1;
        if (this.homeFolderChoice.getSelection()) {
            if (this.getFolderLocationString().trim().length() == 0) {
                this.setMessage(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"error.emptyFolderPath"), 3);
                status = -1;
            } else if (this.getFolderLocationString().trim().indexOf(32) >= 0) {
                this.setMessage(Messages.getString("ReplacementFolderSelectionPageHelper.invalidFolderPathNoSpacesAllowed"), 3);
                status = -1;
            } else if (this.verifyFileLocation() == 1) {
                this.setMessage(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"error.invalidFlatFilePath"), 3);
                status = -1;
            }
        } else if (this.fileURIChoice.getSelection()) {
            if (this.getFileURIString().trim().length() == 0) {
                this.setMessage(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"error.emptyFileURIPath"), 3);
                status = -1;
            } else if (this.getFileURIString().trim().indexOf(32) >= 0) {
                this.setMessage(Messages.getString("ReplacementFolderSelectionPageHelper.invalidFileURINoSpacesAllowed"), 3);
                status = -1;
            } else if (this.needsCheckURITest) {
                this.setMessage(org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages.getString((String)"Connection.warning.untested"), 2);
                status = 0;
            }
        }
        if (status == 1) {
            this.setMessage(DEFAULT_MESSAGE, 0);
        }
        this.setPageComplete(status >= 0);
    }
}

