/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import org.fusesource.ide.jmx.commons.messages.Exchange;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.Message;

public class ActiveMQConverter {
    private Set<String> nestedProperties = new HashSet<String>(Arrays.asList("BooleanProperties", "ByteProperties", "ShortProperties", "IntProperties", "LongProperties", "FloatProperties", "DoubleProperties", "StringProperties"));
    private Set<String> bodyKeys = new HashSet<String>(Arrays.asList("Text", "Object", "Bytes", "Map"));
    private Set<String> ignoredKeys = new HashSet<String>(Arrays.asList("PropertiesText"));

    public IExchange toExchange(Object object) {
        if (object instanceof CompositeData) {
            CompositeData data = (CompositeData)object;
            return this.toExchange(data);
        }
        return null;
    }

    public IExchange toExchange(CompositeData data) {
        Message message = new Message();
        Map headers = message.getHeaders();
        Set<String> keySet = data.getCompositeType().keySet();
        for (String key : keySet) {
            Object value = data.get(key);
            if (this.ignoredKeys.contains(key)) continue;
            boolean nestedProperty = this.nestedProperties.contains(key);
            if (nestedProperty && value instanceof TabularData) {
                TabularData td = (TabularData)value;
                Map<String, Object> map = this.toMap(td);
                this.putAllNonNull(headers, map);
                continue;
            }
            if (nestedProperty && value instanceof Map) {
                Map map = (Map)value;
                this.putAllNonNull(headers, map);
                continue;
            }
            if (this.bodyKeys.contains(key)) {
                message.setBody(value);
                continue;
            }
            if (value == null) continue;
            headers.put(key, value);
        }
        headers.entrySet();
        return new Exchange(message);
    }

    protected void putAllNonNull(Map<String, Object> headers, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            Object value = entry.getValue();
            if (value == null) continue;
            headers.put(entry.getKey(), value);
        }
    }

    private Map<String, Object> toMap(TabularData td) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        Collection<?> rows = td.values();
        for (Object row : rows) {
            CompositeData cd;
            Object key;
            if (!(row instanceof CompositeData) || (key = (cd = (CompositeData)row).get("key")) == null) continue;
            Object value = cd.get("value");
            answer.put(key.toString(), value);
        }
        return answer;
    }
}

