/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacadeSupport;
import org.fusesource.ide.jmx.activemq.internal.BrokerViewFacade;
import org.fusesource.ide.jmx.activemq.internal.QueueViewFacade;

public abstract class RemoteBrokerFacadeSupport
extends BrokerFacadeSupport {
    private String brokerName;

    public RemoteBrokerFacadeSupport() {
    }

    public RemoteBrokerFacadeSupport(String brokerName) {
        this.brokerName = brokerName;
    }

    @Override
    public String getBrokerName() throws Exception, MalformedObjectNameException {
        return this.getBrokerAdmin().getBrokerName();
    }

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    private ObjectName getBrokerObjectName(MBeanServerConnection connection) throws IOException, MalformedObjectNameException {
        Set<ObjectName> brokers = this.findBrokers(connection);
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = brokers.iterator().next();
        return name;
    }

    @Override
    public BrokerViewFacade getBrokerAdmin() throws Exception {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        Set<ObjectName> brokers = this.findBrokers(connection);
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = brokers.iterator().next();
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        return RemoteBrokerFacadeSupport.proxy(BrokerViewFacade.class, mbean, name.getCanonicalName());
    }

    @Override
    public String getId() throws Exception {
        Set<ObjectName> brokers = this.findBrokers(this.getMBeanServerConnection());
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = brokers.iterator().next();
        return name.getCanonicalName();
    }

    public String[] getBrokerNames() throws Exception {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        ObjectName names = new ObjectName("org.apache.activemq:type=Broker,brokerName=*");
        HashSet<String> rc = new HashSet<String>();
        Set<ObjectName> objectNames = connection.queryNames(names, null);
        for (ObjectName name : objectNames) {
            String bn = name.getKeyProperty("brokerName");
            if (bn == null) continue;
            rc.add(bn);
        }
        return rc.toArray(new String[rc.size()]);
    }

    protected abstract MBeanServerConnection getMBeanServerConnection() throws Exception;

    protected Set<ObjectName> findBrokers(MBeanServerConnection connection) throws IOException, MalformedObjectNameException {
        ObjectName name = this.brokerName == null ? new ObjectName("org.apache.activemq:type=Broker,brokerName=*") : new ObjectName("org.apache.activemq:brokerName=" + this.brokerName + ",type=Broker");
        Set<ObjectName> brokers = connection.queryNames(name, null);
        return brokers;
    }

    @Override
    public void purgeQueue(ActiveMQDestination destination) throws Exception {
        QueueViewFacade queue = this.getQueue(destination.getPhysicalName());
        queue.purge();
    }

    @Override
    public ManagementContext getManagementContext() {
        throw new IllegalStateException("not supported");
    }

    protected <T> Collection<T> getManagedObjects(ObjectName[] names, Class<T> type) {
        MBeanServerConnection connection;
        try {
            connection = this.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<T> answer = new ArrayList<T>();
        if (connection != null) {
            int i = 0;
            while (i < names.length) {
                ObjectName name = names[i];
                T value = MBeanServerInvocationHandler.newProxyInstance(connection, name, type, true);
                if (value != null) {
                    answer.add(value);
                }
                ++i;
            }
        }
        return answer;
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.getMBeanServerConnection().queryNames(name, query);
    }

    @Override
    public Object newProxyInstance(ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) throws Exception {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServerConnection(), objectName, interfaceClass, notificationBroadcaster);
    }

    protected boolean isConnectionActive(JMXConnector connector) {
        if (connector == null) {
            return false;
        }
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            int brokerCount = this.findBrokers(connection).size();
            return brokerCount > 0;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

