/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.jmx.content.navigator.providers;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.JmxTemplateBrokerFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.commons.JmxPluginJmxTemplate;
import org.fusesource.ide.jmx.commons.JmxTemplateSupport;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.Root;

public class ActiveMQNodeContentProvider
implements ITreeContentProvider {
    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IConnectionWrapper) {
            IConnectionWrapper w = (IConnectionWrapper)parentElement;
            Root r = w.getRoot();
            if (r != null && r.containsDomain("org.apache.activemq")) {
                JmxTemplateBrokerFacade facade = new JmxTemplateBrokerFacade((JmxTemplateSupport)new JmxPluginJmxTemplate(r.getConnection()));
                String brokerName = null;
                try {
                    brokerName = facade.getBrokerName();
                }
                catch (Exception e) {
                    ActiveMQJMXPlugin.getLogger().warning("Could not find Broker name: " + e, (Throwable)e);
                }
                if (brokerName == null) {
                    brokerName = "Broker";
                }
                BrokerNode broker = new BrokerNode((Node)r, facade, brokerName);
                return new Object[]{broker};
            }
        } else if (parentElement instanceof NodeSupport) {
            NodeSupport contexts = (NodeSupport)parentElement;
            return contexts.getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Node) {
            Node[] children = ((Node)element).getChildren();
            return children != null && children.length > 0;
        }
        return false;
    }
}

