/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.fusesource.ide.foundation.core.util.Objects;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.drop.DropHandler;
import org.fusesource.ide.foundation.ui.drop.DropHandlerFactory;
import org.fusesource.ide.foundation.ui.tree.NodeSupport;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.JmsTypeConverters;
import org.fusesource.ide.jmx.commons.messages.IExchange;
import org.fusesource.ide.jmx.commons.messages.IMessage;
import org.fusesource.ide.jmx.commons.tree.MessageDropHandler;
import org.fusesource.ide.jmx.commons.tree.MessageDropTarget;
import org.jboss.tools.jmx.core.tree.Node;

public abstract class DestinationNodeSupport
extends NodeSupport
implements MessageDropTarget,
DropHandlerFactory {
    protected Set<String> ignoreSendHeaders = new HashSet<String>(Arrays.asList("JMSDestination", "JMSMessageID"));
    private final BrokerNode brokerNode;
    private final DestinationViewMBean destination;

    public DestinationNodeSupport(Node parent, BrokerNode brokerNode, DestinationViewMBean destination) {
        super(parent);
        this.brokerNode = brokerNode;
        this.destination = destination;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.destination.getName();
    }

    public DropHandler createDropHandler(DropTargetEvent event) {
        return new MessageDropHandler((MessageDropTarget)this);
    }

    public void dropMessage(IMessage message) {
        Map headers = message.getHeaders();
        HashMap<String, String> cleanHeaders = new HashMap<String, String>();
        Set entrySet = headers.entrySet();
        for (Map.Entry entry : entrySet) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            String sValue = null;
            if (value == null || this.ignoreSendHeaders.contains(key)) continue;
            if (Objects.equal((Object)"JMSReplyTo", (Object)key)) {
                sValue = JmsTypeConverters.toDestination(value).toString();
            } else if (Objects.equal((Object)"JMSExpiration", (Object)key)) {
                sValue = JmsTypeConverters.toTimestamp(value).toString();
            } else if (Objects.equal((Object)"JMSTimestamp", (Object)key)) {
                sValue = JmsTypeConverters.toTimestamp(value).toString();
            } else if (Objects.equal((Object)"JMSDeliveryMode", (Object)key)) {
                sValue = JmsTypeConverters.toDeliveryMode(value).toString();
            } else if (Objects.equal((Object)"JMSRedelivered", (Object)key)) {
                sValue = JmsTypeConverters.toBoolean(value).toString();
            } else if (Objects.equal((Object)"JMSPriority", (Object)key)) {
                sValue = JmsTypeConverters.toInteger(value).toString();
            }
            if (sValue == null) continue;
            cleanHeaders.put(key, sValue);
        }
        String body = Strings.getOrElse((Object)message.getBody());
        try {
            String userName = this.getBrokerNode().getUserName();
            String password = this.getBrokerNode().getPassword();
            if (userName != null && password != null) {
                this.destination.sendTextMessage(cleanHeaders, body, userName, password);
            } else {
                this.destination.sendTextMessage(cleanHeaders, body);
            }
        }
        catch (Exception e) {
            ActiveMQJMXPlugin.showUserError("Send message to " + (Object)((Object)this) + " failed", "Could not send message to " + (Object)((Object)this), e);
        }
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public DestinationViewMBean getDestination() {
        return this.destination;
    }

    protected IExchange createExchange(Object object) {
        return ActiveMQJMXPlugin.getConverter().toExchange(object);
    }
}

