/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collection;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.internal.SubscriptionViewFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.SubscriptionNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicConsumersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final TopicNode queueNode;

    public TopicConsumersNode(TopicNode queueNode) {
        super((Node)queueNode);
        this.queueNode = queueNode;
        this.brokerNode = queueNode.getBrokerNode();
        this.facade = queueNode.getFacade();
    }

    public String toString() {
        return "Consumers";
    }

    protected void loadChildren() {
        try {
            Collection<SubscriptionViewFacade> list = this.getFacade().getTopicConsumers(this.queueNode.getName());
            if (list != null) {
                for (SubscriptionViewFacade mbean : list) {
                    this.addChild((Node)new SubscriptionNode((Node)this, mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("listeners.gif");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof TopicConsumersNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable()) {
            return ("AMQTopicConsumersNode-" + this.brokerNode.toString() + "-" + this.queueNode.getName() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

