/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.activemq.broker.jmx.DestinationViewMBean;
import org.apache.activemq.broker.jmx.TopicViewMBean;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.fusesource.ide.foundation.ui.tree.ConnectedNode;
import org.fusesource.ide.foundation.ui.tree.GraphableNode;
import org.fusesource.ide.foundation.ui.util.ContextMenuProvider;
import org.fusesource.ide.foundation.ui.util.Shells;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.Messages;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.navigator.DestinationNodeSupport;
import org.fusesource.ide.jmx.activemq.navigator.TopicConsumersNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicDurableConsumersNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicProducersNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicsNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicNode
extends DestinationNodeSupport
implements ImageProvider,
ContextMenuProvider,
GraphableNode,
ConnectedNode {
    private final TopicsNode topicsNode;
    private final TopicViewMBean topic;
    private final TopicConsumersNode consumersNode;
    private final TopicProducersNode producersNode;
    private final TopicDurableConsumersNode durableConsumersNode;

    public TopicNode(TopicsNode topicsNode, TopicViewMBean topic) {
        super((Node)topicsNode, topicsNode.getBrokerNode(), (DestinationViewMBean)topic);
        this.topicsNode = topicsNode;
        this.topic = topic;
        this.consumersNode = new TopicConsumersNode(this);
        this.durableConsumersNode = new TopicDurableConsumersNode(this);
        this.producersNode = new TopicProducersNode(this);
        this.addChild((Node)this.consumersNode);
        this.addChild((Node)this.durableConsumersNode);
        this.addChild((Node)this.producersNode);
        this.setPropertyBean(topic);
    }

    @Override
    public String toString() {
        return this.topic.getName();
    }

    public TopicsNode getTopicsNode() {
        return this.topicsNode;
    }

    public TopicViewMBean getTopic() {
        return this.topic;
    }

    public List<Node> getConsumerChildren() {
        ArrayList<Node> answer = new ArrayList<Node>();
        answer.addAll(Arrays.asList(this.consumersNode.getChildren()));
        answer.addAll(Arrays.asList(this.durableConsumersNode.getChildren()));
        return answer;
    }

    public List<Node> getChildrenGraph() {
        List<Node> answer = this.getConsumerChildren();
        answer.addAll(Arrays.asList(this.producersNode.getChildren()));
        return answer;
    }

    public List<?> getConnectedTo() {
        return this.getConsumerChildren();
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("topic.png");
    }

    public void provideContextMenu(IMenuManager menu) {
        Action deleteTopicAction = new Action(Messages.DeleteTopicAction, 32){

            public void run() {
                TopicNode.this.showDeleteTopicDialog();
            }
        };
        deleteTopicAction.setToolTipText(Messages.DeleteTopicActionToolTip);
        deleteTopicAction.setImageDescriptor(ActiveMQJMXPlugin.getDefault().getImageDescriptor("delete.gif"));
        menu.add((IAction)deleteTopicAction);
    }

    protected void showDeleteTopicDialog() {
        String message = Messages.bind((String)Messages.DeleteTopicDialogMessage, (Object)this.topic.getName());
        boolean confirm = MessageDialog.openConfirm((Shell)Shells.getShell(), (String)Messages.DeleteTopicDialogTitle, (String)message);
        if (confirm) {
            this.deleteTopic();
        }
    }

    protected void deleteTopic() {
        String name = this.topic.getName();
        try {
            this.getFacade().getBrokerAdmin().removeTopic(name);
            this.topicsNode.refresh();
        }
        catch (Exception e) {
            ActiveMQJMXPlugin.showUserError("Failed to delete Topic", "Failed to delete topic: " + this.topic, e);
        }
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof TopicNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable()) {
            return ("AMQTopicNode-" + this.topicsNode.toString() + "-" + this.consumersNode.toString() + "-" + this.producersNode.toString() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

