/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.jmx.activemq.navigator;

import java.util.Collection;
import org.eclipse.swt.graphics.Image;
import org.fusesource.ide.foundation.ui.tree.RefreshableCollectionNode;
import org.fusesource.ide.jmx.activemq.ActiveMQJMXPlugin;
import org.fusesource.ide.jmx.activemq.internal.BrokerFacade;
import org.fusesource.ide.jmx.activemq.internal.ProducerViewFacade;
import org.fusesource.ide.jmx.activemq.navigator.BrokerNode;
import org.fusesource.ide.jmx.activemq.navigator.ProducerNode;
import org.fusesource.ide.jmx.activemq.navigator.TopicNode;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.ui.ImageProvider;

public class TopicProducersNode
extends RefreshableCollectionNode
implements ImageProvider {
    private final BrokerNode brokerNode;
    private final BrokerFacade facade;
    private final TopicNode topicNode;

    public TopicProducersNode(TopicNode topicNode) {
        super((Node)topicNode);
        this.topicNode = topicNode;
        this.brokerNode = topicNode.getBrokerNode();
        this.facade = topicNode.getFacade();
    }

    public String toString() {
        return "Producers";
    }

    protected void loadChildren() {
        try {
            Collection<ProducerViewFacade> list = this.getFacade().getTopicProducers(this.topicNode.getName());
            if (list != null) {
                for (ProducerViewFacade mbean : list) {
                    this.addChild((Node)new ProducerNode((Node)this, (Node)this.topicNode, mbean));
                }
            }
        }
        catch (Exception e) {
            this.brokerNode.handleException((Node)this, e);
        }
    }

    public void refresh() {
        this.getBrokerNode().refresh();
    }

    public BrokerNode getBrokerNode() {
        return this.brokerNode;
    }

    public Image getImage() {
        return ActiveMQJMXPlugin.getDefault().getImage("topic_folder.png");
    }

    protected BrokerFacade getFacade() {
        return this.getBrokerNode().getFacade();
    }

    public boolean equals(Object obj) {
        return obj instanceof TopicProducersNode && obj.hashCode() == this.hashCode();
    }

    public int hashCode() {
        if (this.isConnectionAvailable()) {
            return ("AMQTopicProducersNode-" + this.brokerNode.toString() + "-" + this.topicNode.getName() + "-" + this.toString() + "-" + this.getConnection().getProvider().getName(this.getConnection())).hashCode();
        }
        return super.hashCode();
    }
}

