/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.sdt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.BundleContext;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.PluginUtilImpl;
import org.teiid.designer.metamodels.xsd.XsdResourceFactory;

public class ModelerSdtPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.teiid.designer.sdt";
    public static final String PACKAGE_ID = ModelerSdtPlugin.class.getPackage().getName();
    private static final String I18N_NAME = String.valueOf(PACKAGE_ID) + ".i18n";
    public static final PluginUtil Util = new PluginUtilImpl("org.teiid.designer.sdt", I18N_NAME, ResourceBundle.getBundle(I18N_NAME));
    protected static ResourceSet globalResourceSet;
    protected static Resource builtInTypesResource;
    protected static URI BUILTIN_DATATYPES_URI;
    private static ModelerSdtPlugin plugin;
    protected URL baseURL;
    public static boolean DEBUG;

    static {
        BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
        plugin = new ModelerSdtPlugin();
        DEBUG = false;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        ((PluginUtilImpl)Util).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ModelerSdtPlugin getDefault() {
        return plugin;
    }

    public static synchronized ResourceSet getGlobalResourceSet() {
        if (globalResourceSet == null) {
            globalResourceSet = ModelerSdtPlugin.createResourceSet();
            ModelerSdtPlugin.loadBuiltInTypesResource(globalResourceSet);
        }
        return globalResourceSet;
    }

    public static synchronized Resource getBuiltInTypesResource() {
        if (builtInTypesResource == null) {
            builtInTypesResource = ModelerSdtPlugin.getGlobalResourceSet().getResource(BUILTIN_DATATYPES_URI, true);
        }
        return builtInTypesResource;
    }

    protected static ResourceSet createResourceSet() {
        ResourceSetImpl result = new ResourceSetImpl();
        Map map = result.getResourceFactoryRegistry().getExtensionToFactoryMap();
        if (!map.containsKey("xsd")) {
            map.put("xsd", new XsdResourceFactory());
        }
        return result;
    }

    protected static void loadBuiltInTypesResource(ResourceSet rs) {
        block14: {
            try {
                String baseURL = ModelerSdtPlugin.getDefault().getBaseURL().getFile();
                File baseFolder = new File(baseURL);
                File xsdFile = new File(baseFolder, "cache/www.metamatrix.com/metamodels/builtInDataTypes.xsd");
                File zipFile = new File(baseFolder, "builtInDatatypes.zip");
                URI uri = null;
                Resource r = null;
                if (xsdFile.exists()) {
                    uri = URI.createFileURI((String)xsdFile.getAbsolutePath());
                    r = rs.getResource(uri, true);
                    ModelerSdtPlugin.addLogicalToPhysicalUriMapping(rs, r);
                    break block14;
                }
                if (!zipFile.exists()) break block14;
                InputStream is = null;
                ZipFile archive = null;
                try {
                    archive = new ZipFile(zipFile);
                    ZipEntry entry = archive.getEntry("builtInDataTypes.xsd");
                    if (entry != null) {
                        is = archive.getInputStream(entry);
                        xsdFile = new File(String.valueOf(baseURL) + "builtInDataTypes.xsd");
                        FileUtils.write((InputStream)is, (File)xsdFile);
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (archive != null) {
                        archive.close();
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (archive != null) {
                    archive.close();
                }
                uri = URI.createFileURI((String)xsdFile.getAbsolutePath());
                r = rs.getResource(uri, true);
                ModelerSdtPlugin.addLogicalToPhysicalUriMapping(rs, r);
            }
            catch (Throwable e) {
                Object[] params = new Object[]{"builtInDataTypes.xsd", "builtInDatatypes.zip"};
                String msg = Util.getString("ModelerSdtPlugin.Error_loading_builtin_types_resource", params);
                Util.log(4, e, msg);
                e.printStackTrace();
            }
        }
    }

    protected static void addLogicalToPhysicalUriMapping(ResourceSet rs, Resource r) {
        CoreArgCheck.isNotNull((Object)rs);
        CoreArgCheck.isNotNull((Object)r);
        URI logicalURI = BUILTIN_DATATYPES_URI;
        URI physicalURI = r.getURI();
        rs.getURIConverter().getURIMap().put(logicalURI, physicalURI);
    }

    public URL getBaseURL() {
        block16: {
            if (this.baseURL == null && plugin != null && plugin.getBundle() != null) {
                try {
                    this.baseURL = FileLocator.resolve((URL)plugin.getBundle().getEntry("/"));
                }
                catch (IOException iOException) {
                    this.baseURL = null;
                }
            }
            if (this.baseURL == null) {
                try {
                    Class<?> theClass = ((Object)((Object)this)).getClass();
                    URL pluginPropertiesURL = theClass.getResource("plugin.properties");
                    if (pluginPropertiesURL == null) {
                        String className = theClass.getName();
                        int index = className.lastIndexOf(".");
                        URL classURL = theClass.getResource(String.valueOf(index == -1 ? className : className.substring(index + 1)) + ".class");
                        URI uri = URI.createURI((String)classURL.toString());
                        int count = 1;
                        int i = 0;
                        while ((i = className.indexOf(46, i)) != -1) {
                            ++count;
                            ++i;
                        }
                        if (URI.isArchiveScheme((String)(uri = uri.trimSegments(count)).scheme())) {
                            try {
                                InputStream inputStream = new URL(uri.appendSegment("plugin.properties").toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(uri.toString());
                            }
                            catch (IOException iOException) {
                                uri = URI.createURI((String)uri.authority()).trimSegments(1);
                            }
                        }
                        if (this.baseURL == null) {
                            String lastSegment = uri.lastSegment();
                            if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                                uri = uri.trimSegments(1);
                            }
                            uri = uri.appendSegment("plugin.properties");
                            try {
                                InputStream inputStream = new URL(uri.toString()).openStream();
                                inputStream.close();
                                this.baseURL = new URL(String.valueOf(uri.trimSegments(1).toString()) + "/");
                            }
                            catch (IOException iOException) {}
                        }
                        if (this.baseURL == null) {
                            String resourceName = index == -1 ? "plugin.properties" : String.valueOf(className.substring(0, index + 1).replace('.', '/')) + "plugin.properties";
                            throw new MissingResourceException("Missing properties: " + resourceName, theClass.getName(), "plugin.properties");
                        }
                        break block16;
                    }
                    this.baseURL = new URL(String.valueOf(URI.createURI((String)pluginPropertiesURL.toString()).trimSegments(1).toString()) + "/");
                }
                catch (IOException exception) {
                    throw new WrappedException((Exception)exception);
                }
            }
        }
        return this.baseURL;
    }
}

