/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.sdt.types;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.TransactionRunnable;
import org.teiid.designer.core.metamodel.aspect.sql.SqlDatatypeAspect;
import org.teiid.designer.core.transaction.UnitOfWork;
import org.teiid.designer.core.types.DatatypeConstants;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.types.EnterpriseDatatypeInfo;
import org.teiid.designer.sdt.ModelerSdtPlugin;
import org.teiid.designer.sdt.types.AbstractDatatypeManager;

public class BuiltInTypesManager
extends AbstractDatatypeManager {
    protected static final String XSD_SCHEMA_URI_STRING = "http://www.w3.org/2001/XMLSchema";
    protected static final String MAGIC_SCHEMA_URI_STRING = "http://www.w3.org/2001/MagicXMLSchema";
    protected static final String ANY_TYPE_NAME = "anyType";
    protected static final String ANY_TYPE_URI_STRING = String.valueOf(ModelerCore.XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI) + "#//anyType;XSDSimpleTypeDefinition";
    protected static final URI ANY_TYPE_URI = URI.createURI((String)ANY_TYPE_URI_STRING);
    protected static final String ANY_SIMPLE_TYPE_NAME = "anySimpleType";
    protected static final String ANY_SIMPLE_TYPE_URI_STRING = String.valueOf(ModelerCore.XML_MAGIC_SCHEMA_ECLIPSE_PLATFORM_URI) + "#//anySimpleType;XSDSimpleTypeDefinition=1";
    protected static final URI ANY_SIMPLE_TYPE_URI = URI.createURI((String)ANY_SIMPLE_TYPE_URI_STRING);
    public static final String BUILTIN_DATATYPES_URI_STRING = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
    public static final URI BUILTIN_DATATYPES_URI = URI.createURI((String)"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
    Map emfDatatypeMap;
    Map mmDatatypeMap;
    private Map uuidToMmTypeMap;
    private Map mmTypeToUuidStringMap;
    private Map mmTypeToRuntimeTypeNameMap;
    private EObject anyType;
    private EObject anySimpleType;
    private List primitiveTypes;
    private Resource emfResource;
    private Resource mmResource;
    private boolean hasEMFEnterpriseInfoInit;

    @Override
    protected void doInitialize() {
        this.init();
    }

    public DatatypeManager getBuiltInTypeManager() {
        return this;
    }

    public ObjectID getUuid(EObject type) {
        EObject mmType = this.getMmType(type);
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(mmType);
        if (aspect != null) {
            return (ObjectID)aspect.getObjectID(mmType);
        }
        return null;
    }

    public String getUuidString(EObject type) {
        SqlDatatypeAspect aspect;
        String uuidString = null;
        EObject mmType = this.getMmType(type);
        uuidString = (String)this.mmTypeToUuidStringMap.get(mmType);
        if (uuidString == null && (aspect = BuiltInTypesManager.getSqlAspect(mmType)) != null) {
            uuidString = aspect.getUuidString(mmType);
            this.mmTypeToUuidStringMap.put(mmType, uuidString);
        }
        return uuidString;
    }

    public String getRuntimeTypeName(EObject type) {
        SqlDatatypeAspect aspect;
        if (type == this.anySimpleType || type == this.anyType) {
            return "object";
        }
        EObject mmType = this.getMmType(type);
        String theRuntimeTypeName = (String)this.mmTypeToRuntimeTypeNameMap.get(mmType);
        if (theRuntimeTypeName == null && (aspect = BuiltInTypesManager.getSqlAspect(mmType)) != null) {
            theRuntimeTypeName = aspect.getRuntimeTypeName(mmType);
            this.mmTypeToRuntimeTypeNameMap.put(mmType, theRuntimeTypeName);
        }
        return theRuntimeTypeName;
    }

    public Boolean getRuntimeTypeFixed(EObject type) {
        EObject mmType;
        SqlDatatypeAspect aspect;
        Boolean result = null;
        if (type == this.anySimpleType || type == this.anyType) {
            result = Boolean.FALSE;
        }
        if ((aspect = BuiltInTypesManager.getSqlAspect(mmType = this.getMmType(type))) != null) {
            result = aspect.getRuntimeTypeFixed(mmType);
        }
        return result;
    }

    public Map getEnterpriseExtensionsMap(EObject type) {
        EObject mmType = this.getMmType(type);
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(mmType);
        if (aspect != null) {
            return aspect.getEnterpriseExtensionsMap(mmType);
        }
        return Collections.EMPTY_MAP;
    }

    public String getName(EObject type) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.getName(type);
        }
        return null;
    }

    public boolean isSimpleDatatype(EObject type) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(type);
        if (aspect != null) {
            return aspect.isSimpleDatatype(type);
        }
        return false;
    }

    public EObject getAnySimpleType() {
        if (this.anySimpleType == null) {
            this.anySimpleType = XSDSchemaImpl.getGlobalResourceSet().getEObject(ANY_SIMPLE_TYPE_URI, true);
        }
        return this.anySimpleType;
    }

    public EObject getAnyType() {
        if (this.anyType == null) {
            this.anyType = XSDSchemaImpl.getGlobalResourceSet().getEObject(ANY_TYPE_URI, true);
        }
        return this.anyType;
    }

    public EObject getDefaultDatatypeForRuntimeTypeName(String runtimeTypeName) {
        String builtInTypeName = DatatypeConstants.getDatatypeNamefromRuntimeType((String)runtimeTypeName);
        if (builtInTypeName != null) {
            return this.getBuiltInDatatype(builtInTypeName);
        }
        return null;
    }

    public boolean isBuiltInDatatype(EObject datatype) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(datatype);
        if (aspect != null) {
            return aspect.isBuiltInDatatype(datatype);
        }
        return false;
    }

    public EObject getBaseType(EObject datatype) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(datatype);
        if (aspect != null) {
            XSDSimpleTypeDefinition emfType;
            if (aspect.isURType(datatype)) {
                return null;
            }
            XSDSimpleTypeDefinition entity = (XSDSimpleTypeDefinition)datatype;
            XSDSimpleTypeDefinition basetype = (XSDSimpleTypeDefinition)aspect.getBasetype((EObject)entity);
            try {
                XSDVariety variety = entity.getVariety();
                if (variety == XSDVariety.LIST_LITERAL) {
                    basetype = entity.getItemTypeDefinition();
                } else if (variety == XSDVariety.UNION_LITERAL) {
                    basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
                }
                if (basetype == null) {
                    basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
                } else if (basetype.getName() == null) {
                    basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
                }
                if (XSDConstants.isAnySimpleType((XSDTypeDefinition)basetype)) {
                    basetype = (XSDSimpleTypeDefinition)this.getAnySimpleType();
                }
            }
            catch (Throwable e) {
                ModelerSdtPlugin.Util.log(4, e, ModelerSdtPlugin.Util.getString("DatatypeManagerImpl.Error_retrieving_the_basetype_for_datatype_1", (Object)datatype));
                basetype = null;
            }
            if ((emfType = (XSDSimpleTypeDefinition)this.getEmfType((EObject)basetype)) != null) {
                basetype = emfType;
            }
            return basetype;
        }
        return null;
    }

    public EObject getDatatypeForXsdType(EObject eObject) {
        CoreArgCheck.isNotNull((Object)eObject);
        if (eObject instanceof XSDSimpleTypeDefinition) {
            return this.getDatatypeForXsdType((XSDSimpleTypeDefinition)eObject);
        }
        if (eObject instanceof XSDComplexTypeDefinition) {
            return this.getDatatypeForXsdType((XSDComplexTypeDefinition)eObject);
        }
        return null;
    }

    public EObject[] getAllDatatypes() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.add(this.getAnySimpleType());
        for (XSDTypeDefinition mmType : this.mmDatatypeMap.values()) {
            String mmTypeName = mmType.getName().toLowerCase();
            XSDTypeDefinition emfType = (XSDTypeDefinition)this.emfDatatypeMap.get(mmTypeName);
            if (emfType != null) {
                tmp.add(emfType);
                continue;
            }
            tmp.add(mmType);
        }
        BuiltInTypesManager.removeDuplicates(tmp);
        BuiltInTypesManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableBaseTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(this.getAnySimpleType());
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableItemTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableMemberTypeValues(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.addAll(Arrays.asList(this.getAllDatatypes()));
        tmp.remove(datatype);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getAllowableTypeValues(EObject eObject, EStructuralFeature feature) {
        if (feature == null || eObject == null) {
            return this.getAllDatatypes();
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 28) {
            return this.getAllowableBaseTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 30) {
            return this.getAllowableItemTypeValues(eObject);
        }
        if (eObject instanceof XSDSimpleTypeDefinition && feature.getFeatureID() == 26) {
            return this.getAllowableMemberTypeValues(eObject);
        }
        return this.getAllDatatypes();
    }

    public EObject getBuiltInDatatype(String name) {
        int beginIndex;
        CoreArgCheck.isNotNull((Object)name);
        String id = name;
        if (id.startsWith(XSD_SCHEMA_URI_STRING) && id.indexOf("#") >= 0 && (id = id.substring(beginIndex = id.indexOf("#") + 1)).startsWith("//") && id.indexOf(59) > 0) {
            id = id.substring(2, id.indexOf(59));
        }
        if (id.startsWith(BUILTIN_DATATYPES_URI_STRING) && id.indexOf("#") >= 0 && (id = id.substring(beginIndex = id.indexOf("#") + 1)).startsWith("//") && id.indexOf(59) > 0) {
            id = id.substring(2, id.indexOf(59));
        }
        if (id.equalsIgnoreCase(ANY_TYPE_NAME)) {
            return this.getAnyType();
        }
        if (id.equalsIgnoreCase(ANY_SIMPLE_TYPE_NAME)) {
            return this.getAnySimpleType();
        }
        EObject mmType = null;
        mmType = id.startsWith("mmuuid") ? (EObject)this.uuidToMmTypeMap.get(id) : (EObject)this.mmDatatypeMap.get(id.toLowerCase());
        if (mmType != null) {
            return this.getEmfType(mmType);
        }
        return mmType;
    }

    public EObject findDatatype(String id) {
        EObject result = this.getBuiltInDatatype(id);
        if (result != null) {
            return result;
        }
        EObject rv = this.findEObject(id);
        if (rv instanceof XSDSimpleTypeDefinition) {
            return rv;
        }
        return null;
    }

    public String getRuntimeTypeJavaClassName(String id) {
        EObject type = this.getBuiltInDatatype(id);
        EObject mmType = this.getMmType(type);
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(mmType);
        if (aspect != null) {
            return aspect.getJavaClassName(mmType);
        }
        return null;
    }

    public String getRuntimeTypeName(String id) {
        EObject type = this.getBuiltInDatatype(id);
        return this.getRuntimeTypeName(type);
    }

    public EObject[] getSubtypes(EObject datatype) {
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        EObject[] allTypes = this.getAllDatatypes();
        int i = 0;
        while (i < allTypes.length) {
            EObject type = allTypes[i];
            EObject baseType = this.getBaseType(type);
            if (baseType == datatype) {
                tmp.add(type);
            }
            ++i;
        }
        if (datatype == this.getAnyType() && !tmp.contains(this.getAnySimpleType())) {
            tmp.add(this.getAnySimpleType());
        }
        BuiltInTypesManager.removeDuplicates(tmp);
        BuiltInTypesManager.sortByName(tmp);
        return tmp.toArray(new EObject[tmp.size()]);
    }

    public EObject[] getBuiltInPrimitiveTypes() {
        List primTypes = this.getPrimitiveTypesList();
        return primTypes.toArray(new EObject[primTypes.size()]);
    }

    public EObject getBuiltInPrimitiveType(EObject type) {
        CoreArgCheck.isNotNull((Object)type);
        List primTypes = this.getPrimitiveTypesList();
        EObject simpleType = type;
        while (!primTypes.contains(simpleType)) {
            EObject baseType = this.getBaseType(simpleType);
            if (simpleType == baseType) {
                return null;
            }
            simpleType = baseType;
        }
        return simpleType;
    }

    public boolean isBinary(EObject type) {
        String typeName;
        CoreArgCheck.isNotNull((Object)type);
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.getExtendedBuiltInBaseType(type);
        if (simpleType != null && ("object".equals(typeName = simpleType.getName()) || "blob".equals(typeName) || "clob".equals(typeName))) {
            return true;
        }
        simpleType = (XSDSimpleTypeDefinition)this.getBuiltInPrimitiveType(type);
        return simpleType != null && ("base64Binary".equals(typeName = simpleType.getName()) || "hexBinary".equals(typeName));
    }

    public boolean isCharacter(EObject type) {
        CoreArgCheck.isNotNull((Object)type);
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.getBuiltInPrimitiveType(type);
        return simpleType != null && "string".equals(simpleType.getName());
    }

    public boolean isNumeric(EObject type) {
        CoreArgCheck.isNotNull((Object)type);
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.getBuiltInPrimitiveType(type);
        return simpleType != null && simpleType.getNumericFacet().isValue();
    }

    public boolean isBounded(EObject type) {
        CoreArgCheck.isNotNull((Object)type);
        XSDSimpleTypeDefinition simpleType = (XSDSimpleTypeDefinition)this.getBuiltInPrimitiveType(type);
        return simpleType != null && simpleType.getBoundedFacet().isValue();
    }

    public boolean isEnumeration(EObject type) {
        XSDSimpleTypeDefinition simpleType;
        CoreArgCheck.isNotNull((Object)type);
        return type instanceof XSDSimpleTypeDefinition && (simpleType = (XSDSimpleTypeDefinition)type).getEnumerationFacets().size() > 0;
    }

    public String getDescription(EObject type) {
        String description = null;
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(type);
        if (aspect != null) {
            description = aspect.getDescription(type);
        }
        return description == null ? "" : description;
    }

    public EObject getDatatypeForXsdType(XSDSimpleTypeDefinition simpleType) {
        CoreArgCheck.isNotNull((Object)simpleType);
        XSDSimpleTypeDefinition builtInType = simpleType;
        while (!this.isBuiltInDatatype((EObject)builtInType)) {
            EObject baseType = this.getBaseType((EObject)simpleType);
            if (builtInType == baseType) {
                builtInType = null;
                break;
            }
            builtInType = baseType;
        }
        if (builtInType == null) {
            return this.getAnySimpleType();
        }
        return this.getBuiltInDatatype(builtInType.getName());
    }

    public EObject getDatatypeForXsdType(XSDComplexTypeDefinition complexType) {
        CoreArgCheck.isNotNull((Object)complexType);
        return null;
    }

    public EObject getExtendedBuiltInBaseType(EObject type) {
        CoreArgCheck.isNotNull((Object)type);
        CoreArgCheck.isInstanceOf(XSDSimpleTypeDefinition.class, (Object)type);
        List mmExtendedTypes = this.getExtendedTypesList();
        EObject[] typeHierarchy = this.getTypeHierarchy(type);
        int i = 0;
        while (i != typeHierarchy.length) {
            if (mmExtendedTypes.contains(typeHierarchy[i])) {
                return typeHierarchy[i];
            }
            ++i;
        }
        return null;
    }

    public List getExtendedTypesList() {
        ArrayList<EObject> mmExtendedTypes = new ArrayList<EObject>();
        Collection mmExtendedTypeNames = DatatypeConstants.getMetaMatrixExtendedBuiltInTypeNames();
        for (String extendedTypeName : mmExtendedTypeNames) {
            EObject extendedType = (EObject)this.mmDatatypeMap.get(extendedTypeName.toLowerCase());
            if (extendedType == null) continue;
            mmExtendedTypes.add(extendedType);
        }
        return mmExtendedTypes;
    }

    @Override
    protected List getDatatypeResources() {
        if (this.mmResource != null) {
            return Collections.singletonList(this.mmResource);
        }
        return Collections.EMPTY_LIST;
    }

    protected EObject getEmfType(EObject type) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(type);
        if (aspect != null && aspect.isBuiltInDatatype(type)) {
            String typeName = ((XSDTypeDefinition)type).getName();
            EObject emfType = (EObject)this.emfDatatypeMap.get(typeName.toLowerCase());
            if (emfType != null) {
                return emfType;
            }
            return type;
        }
        return null;
    }

    protected EObject getMmType(EObject type) {
        String typeName;
        EObject emfType;
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(type);
        if (aspect != null && aspect.isBuiltInDatatype(type) && (emfType = (EObject)this.mmDatatypeMap.get((typeName = ((XSDTypeDefinition)type).getName()).toLowerCase())) != null) {
            return emfType;
        }
        return null;
    }

    protected EObject findEObject(String id) {
        if (id == null) {
            return null;
        }
        if (this.emfResource instanceof XSDResourceImpl && id.startsWith("mmuuid")) {
            return (EObject)this.uuidToMmTypeMap.get(id);
        }
        EObject result = this.emfResource.getEObject(id);
        if (result == null) {
            result = this.mmResource.getEObject(id);
        }
        return result;
    }

    protected void init() {
        this.primitiveTypes = null;
        this.emfResource = null;
        this.mmResource = null;
        this.emfDatatypeMap = new HashMap();
        this.mmDatatypeMap = new HashMap();
        this.uuidToMmTypeMap = new HashMap();
        this.mmTypeToUuidStringMap = new HashMap();
        this.mmTypeToRuntimeTypeNameMap = new HashMap();
        this.initializeEmfDatatypeMap();
        this.initializeMmDatatypeMap();
        this.initializeUuidToMmTypeMap();
    }

    private List getPrimitiveTypesList() {
        if (this.primitiveTypes == null) {
            this.primitiveTypes = new ArrayList();
            try {
                EObject[] allTypes = this.getAllDatatypes();
                int i = 0;
                while (i < allTypes.length) {
                    EObject type = allTypes[i];
                    EObject baseType = this.getBaseType(type);
                    if (baseType == this.getAnySimpleType() || baseType == this.getAnyType()) {
                        this.primitiveTypes.add(type);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                String msg = ModelerSdtPlugin.Util.getString("BuiltInTypesManager.Error_constructing_the_list_of_built-in_primitive_types_1", new Object[0]);
                ModelerSdtPlugin.Util.log(4, e, msg);
            }
            BuiltInTypesManager.removeDuplicates(this.primitiveTypes);
            BuiltInTypesManager.sortByName(this.primitiveTypes);
        }
        return this.primitiveTypes;
    }

    private void initializeEmfDatatypeMap() {
        XSDSchema schema = XSDSchemaImpl.getSchemaForSchema((String)XSD_SCHEMA_URI_STRING);
        for (EObject eObject : schema.getContents()) {
            if (!(eObject instanceof XSDSimpleTypeDefinition)) continue;
            XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject;
            String typeName = type.getName();
            if (!DatatypeConstants.getBuiltInTypeNames().contains(typeName)) continue;
            this.emfDatatypeMap.put(typeName.toLowerCase(), type);
        }
        this.emfResource = schema.eResource();
    }

    private void initializeMmDatatypeMap() {
        try {
            Resource resource = this.getContainer().getResource(BUILTIN_DATATYPES_URI, false);
            if (resource == null) {
                Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
                String msg = ModelerSdtPlugin.Util.getString("BuiltInTypesManager.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_1", params);
                throw new RuntimeException(msg);
            }
            this.mmResource = resource;
            for (EObject eObject2 : resource.getContents()) {
                if (eObject2 == null || !(eObject2 instanceof XSDSchema)) continue;
                for (EObject eObject2 : eObject2.eContents()) {
                    if (eObject2 == null || !(eObject2 instanceof XSDSimpleTypeDefinition)) continue;
                    XSDSimpleTypeDefinition type = (XSDSimpleTypeDefinition)eObject2;
                    String typeName = type.getName();
                    this.mmDatatypeMap.put(typeName.toLowerCase(), type);
                }
            }
        }
        catch (Throwable e) {
            Object[] params = new Object[]{BUILTIN_DATATYPES_URI};
            String msg = ModelerSdtPlugin.Util.getString("BuiltInTypesManager.Error_obtain_the_built-in_datatypes_resource_from_the_container_using_URI_2", params);
            ModelerSdtPlugin.Util.log(4, e, msg);
        }
    }

    private void initializeUuidToMmTypeMap() {
        for (EObject type : this.mmDatatypeMap.values()) {
            String uuid = this.getUuidString(type);
            if (uuid == null) continue;
            this.uuidToMmTypeMap.put(uuid, type);
        }
    }

    private void initializeEnterpriseDataForEmfResource() {
        this.hasEMFEnterpriseInfoInit = true;
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) {
                for (XSDSimpleTypeDefinition mmType : BuiltInTypesManager.this.mmDatatypeMap.values()) {
                    String typeName = mmType.getName().toLowerCase();
                    XSDSimpleTypeDefinition emfType = (XSDSimpleTypeDefinition)BuiltInTypesManager.this.emfDatatypeMap.get(typeName);
                    if (emfType == null || BuiltInTypesManager.getSqlAspect((EObject)mmType).isEnterpriseDataType((EObject)emfType)) continue;
                    EnterpriseDatatypeInfo edt = new EnterpriseDatatypeInfo(BuiltInTypesManager.this.getUuidString((EObject)mmType), BuiltInTypesManager.this.getRuntimeTypeName((EObject)mmType), BuiltInTypesManager.this.getRuntimeTypeFixed((EObject)mmType));
                    BuiltInTypesManager.getSqlAspect((EObject)mmType).setEnterpriseDataAttributes(emfType, edt);
                }
                return null;
            }
        };
        try {
            ModelerCore.getModelEditor().executeAsTransaction(runnable, "updating built-in type enterprise info", false, false, (Object)this);
        }
        catch (ModelerCoreException mce) {
            ModelerSdtPlugin.Util.log((Throwable)mce);
        }
    }

    public EObject[] getBuiltInDatatypes() {
        return this.getAllDatatypes();
    }

    public boolean isEnterpriseDatatype(EObject simpleType) {
        SqlDatatypeAspect aspect = BuiltInTypesManager.getSqlAspect(simpleType);
        if (aspect != null) {
            if (!this.hasEMFEnterpriseInfoInit) {
                this.initializeEnterpriseDataForEmfResource();
            }
            return aspect.isEnterpriseDataType(simpleType);
        }
        return false;
    }

    public EnterpriseDatatypeInfo getEnterpriseDatatypeInfo(XSDSimpleTypeDefinition simpleType) {
        if (!this.hasEMFEnterpriseInfoInit) {
            this.initializeEnterpriseDataForEmfResource();
        }
        return BuiltInTypesManager.getSqlAspect((EObject)simpleType).getEnterpriseDatatypeInfo(simpleType);
    }

    public void setBasetypeDefinition(XSDSimpleTypeDefinition simpleType, XSDSimpleTypeDefinition baseType) {
        throw new UnsupportedOperationException();
    }
}

