/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.EquivalenceUtil;
import org.teiid.core.designer.util.ExternalizeUtil;

public class ModelerCoreException
extends CoreException
implements Externalizable {
    private static final String NO_MESSAGE = "No Error Message";
    CoreException nestedCoreException;

    public ModelerCoreException() {
        super((IStatus)new StatusHolder((IStatus)new Status(4, "org.teiid.core.designer", 0, ModelerCoreException.getNonNullMessage(NO_MESSAGE), null)));
    }

    public ModelerCoreException(Throwable e, int code) {
        super((IStatus)new Status(4, "org.teiid.core.designer", code, "", e));
    }

    public ModelerCoreException(CoreException exception) {
        super((IStatus)(exception == null ? new Status(4, "org.teiid.core.designer", 0, "", null) : exception.getStatus()));
        if (exception != null) {
            this.nestedCoreException = exception;
        }
    }

    public ModelerCoreException(IStatus status) {
        super((IStatus)(status == null ? new Status(4, "org.teiid.core.designer", 0, "", null) : status));
    }

    public ModelerCoreException(String message) {
        super((IStatus)new Status(4, "org.teiid.core.designer", 0, ModelerCoreException.getNonNullMessage(message), null));
    }

    public ModelerCoreException(Throwable e) {
        super((IStatus)new Status(4, "org.teiid.core.designer", 0, ModelerCoreException.getNonNullMessageFromThrowable(e), e));
    }

    public ModelerCoreException(Throwable e, String message) {
        super((IStatus)new Status(4, "org.teiid.core.designer", 0, ModelerCoreException.getNonNullMessage(message), e));
    }

    protected String getToStringType() {
        return "Modeler Core Exception";
    }

    static String getNonNullMessage(String message) {
        if (message == null) {
            return "";
        }
        return message;
    }

    static String getNonNullMessageFromThrowable(Throwable t) {
        if (t == null) {
            return "";
        }
        return ModelerCoreException.getNonNullMessage(t.getMessage());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getToStringType());
        buffer.append(":");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException c = (CoreException)this.getException();
                buffer.append(" Core Exception [code ");
                buffer.append(c.getStatus().getCode());
                buffer.append("] ");
                buffer.append(c.getStatus().getMessage());
            } else {
                buffer.append(" ");
                buffer.append(this.getException().toString());
            }
        } else {
            buffer.append(" ");
            buffer.append(this.getStatus().toString());
        }
        return buffer.toString();
    }

    public String getMessage() {
        return this.getStatus().getMessage();
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = ModelerCoreException.readIStatus(in);
        IStatus currentStatus = this.getStatus();
        if (currentStatus instanceof StatusHolder && status != null) {
            ((StatusHolder)currentStatus).setStatus(status);
        }
        StackTraceElement[] stackTrace = (StackTraceElement[])in.readObject();
        this.setStackTrace(stackTrace);
        this.nestedCoreException = (CoreException)this.internalReadThrowable(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ModelerCoreException.writeIStatus(out, this.getStatus());
        out.writeObject(this.getStackTrace());
        this.internalWriteThrowable(out, (Throwable)this.nestedCoreException);
    }

    public static void writeThrowable(ObjectOutput out, Throwable t) throws IOException {
        if (t == null || !(t instanceof CoreException) || t instanceof TeiidDesignerException) {
            out.writeBoolean(false);
            out.writeObject(t);
        } else {
            out.writeBoolean(true);
            ModelerCoreException.writeCoreException(out, (CoreException)t);
        }
    }

    public static void writeCoreException(ObjectOutput out, CoreException e) throws IOException {
        ModelerCoreException.writeIStatus(out, e.getStatus());
        out.writeObject(e.getStackTrace());
    }

    public static void writeIStatus(ObjectOutput out, IStatus status) throws IOException {
        StatusImpl serializableStatus = new StatusImpl(status);
        out.writeObject(serializableStatus);
    }

    public static Throwable readThrowable(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean isCoreException = in.readBoolean();
        if (isCoreException) {
            return ModelerCoreException.readCoreException(in);
        }
        return (Throwable)in.readObject();
    }

    public static CoreException readCoreException(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = ModelerCoreException.readIStatus(in);
        CoreException exception = new CoreException(status);
        StackTraceElement[] stackTrace = (StackTraceElement[])in.readObject();
        exception.setStackTrace(stackTrace);
        return exception;
    }

    public static IStatus readIStatus(ObjectInput in) throws IOException, ClassNotFoundException {
        IStatus status = (IStatus)in.readObject();
        return status;
    }

    private void internalWriteThrowable(ObjectOutput out, Throwable t) throws IOException {
        out.writeObject(t);
    }

    private Throwable internalReadThrowable(ObjectInput in) throws IOException, ClassNotFoundException {
        return (Throwable)in.readObject();
    }

    private static class StatusHolder
    implements IStatus,
    Serializable {
        private static final long serialVersionUID = 1L;
        private IStatus status = null;

        StatusHolder(IStatus status) {
            this.setStatus(status);
        }

        void setStatus(IStatus status) {
            this.status = status;
        }

        public IStatus[] getChildren() {
            return this.status.getChildren();
        }

        public int getCode() {
            return this.status.getCode();
        }

        public Throwable getException() {
            return this.status.getException();
        }

        public String getMessage() {
            return this.status.getMessage();
        }

        public String getPlugin() {
            return this.status.getPlugin();
        }

        public int getSeverity() {
            return this.status.getSeverity();
        }

        public boolean isMultiStatus() {
            return this.status.isMultiStatus();
        }

        public boolean isOK() {
            return this.status.isOK();
        }

        public boolean matches(int severityMask) {
            return this.status.matches(severityMask);
        }
    }

    public static class StatusImpl
    implements IStatus,
    Externalizable {
        public static final long serialVersionUID = 0L;
        private StatusImpl[] children = null;
        private int code = 0;
        private Throwable exception = null;
        private String message = null;
        private String plugin = null;
        private int severity = 0;
        private boolean multiStatus = false;
        private boolean ok = false;

        public StatusImpl() {
        }

        public StatusImpl(IStatus original) {
            if (original.getChildren() != null) {
                int length = original.getChildren().length;
                this.children = new StatusImpl[length];
                int i = 0;
                while (i < length) {
                    if (original.getChildren()[i] != null) {
                        this.children[i] = new StatusImpl(original.getChildren()[i]);
                    }
                    ++i;
                }
            }
            this.code = original.getCode();
            this.exception = original.getException();
            this.message = original.getMessage();
            this.plugin = original.getPlugin();
            this.severity = original.getSeverity();
            this.multiStatus = original.isMultiStatus();
            this.ok = original.isOK();
        }

        public IStatus[] getChildren() {
            return this.children;
        }

        public int getCode() {
            return this.code;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public String getPlugin() {
            return this.plugin;
        }

        public int getSeverity() {
            return this.severity;
        }

        public boolean isMultiStatus() {
            return this.multiStatus;
        }

        public boolean isOK() {
            return this.ok;
        }

        public boolean matches(int severityMask) {
            return (this.severity & severityMask) != 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof IStatus)) {
                return false;
            }
            IStatus other = (IStatus)obj;
            return EquivalenceUtil.areEquivalent(this.children, other.getChildren()) && this.code == other.getCode() && EquivalenceUtil.areEqual(this.message, other.getMessage()) && EquivalenceUtil.areEqual(this.plugin, other.getPlugin()) && this.severity == other.getSeverity() && this.multiStatus == other.isMultiStatus() && this.ok == other.isOK();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            this.children = new StatusImpl[length];
            int i = 0;
            while (i < length) {
                this.children[i] = (StatusImpl)in.readObject();
                ++i;
            }
            this.code = in.readInt();
            this.exception = ModelerCoreException.readThrowable(in);
            this.message = (String)in.readObject();
            this.plugin = (String)in.readObject();
            this.severity = in.readInt();
            this.multiStatus = in.readBoolean();
            this.ok = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            ExternalizeUtil.writeArray(out, this.children);
            out.writeInt(this.code);
            ModelerCoreException.writeThrowable(out, this.exception);
            out.writeObject(this.message);
            out.writeObject(this.plugin);
            out.writeInt(this.severity);
            out.writeBoolean(this.multiStatus);
            out.writeBoolean(this.ok);
        }
    }
}

