/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.id;

import java.io.Serializable;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.LongID;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.id.ObjectIDFactory;
import org.teiid.core.designer.id.ParsedObjectID;

public class LongIDFactory
implements ObjectIDFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    private long lastID = 0L;

    @Override
    public String getDescription() {
        return CoreModelerPlugin.Util.getString("LongIDFactory.Description", new Object[0]);
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    @Override
    public ObjectID create() {
        return new LongID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof LongID;
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new LongID(Long.parseLong(value));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidIDException(CoreModelerPlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new LongID(Long.parseLong(parsedID.getRemainder()));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidIDException(CoreModelerPlugin.Util.getString("LongIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public String getProtocol() {
        return "mmlong";
    }
}

