/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.id;

import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.id.ObjectIDFactory;
import org.teiid.core.designer.id.ParsedObjectID;
import org.teiid.core.designer.id.StringID;

public class StringIDFactory
implements ObjectIDFactory {
    private long lastID = 0L;

    @Override
    public String getDescription() {
        return CoreModelerPlugin.Util.getString("StringIDFactory.Description", new Object[0]);
    }

    protected long getNextValue() {
        return ++this.lastID;
    }

    @Override
    public ObjectID create() {
        return new StringID(this.getNextValue());
    }

    public boolean validate(ObjectID id) {
        return id instanceof StringID;
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        try {
            return new StringID(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidIDException(CoreModelerPlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmlong");
        try {
            return new StringID(parsedID.getRemainder());
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidIDException(CoreModelerPlugin.Util.getString("StringIDFactory.The_specified_ID_value_is_invalid", value, this.getProtocol()));
        }
    }

    @Override
    public String getProtocol() {
        return "strid";
    }
}

