/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.id;

import java.io.Serializable;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.id.InvalidIDException;
import org.teiid.core.designer.id.ObjectID;
import org.teiid.core.designer.util.CoreArgCheck;

public class UUID
implements ObjectID,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String NOT_UUID_MESSAGE = CoreModelerPlugin.Util.getString("UUID.ID_must_be_of_type_UUID_1", new Object[0]);
    private static final String UNPARSABLE_MESSAGE = CoreModelerPlugin.Util.getString("UUID.ID_must_be_of_type_UUID_to_parse_2", new Object[0]);
    public static final String PROTOCOL = "mmuuid";
    public static final String PROTOCOL_UCASE = "mmuuid".toUpperCase();
    private static final int ID_STRING_LEN = 36;
    public static final int FQ_LENGTH = "mmuuid".length() + 1 + 36;
    private final java.util.UUID uuid;
    private String cachedExportableFormUuidString;

    public UUID(long mostSig, long leastSig) {
        this.uuid = new java.util.UUID(mostSig, leastSig);
    }

    public UUID(java.util.UUID uuid) {
        this.uuid = uuid;
    }

    public static long getPart1(ObjectID id) {
        CoreArgCheck.isInstanceOf(UUID.class, id, UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.getMostSignificantBits();
    }

    public static long getPart2(ObjectID id) {
        CoreArgCheck.isInstanceOf(UUID.class, id, UNPARSABLE_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.getLeastSignificantBits();
    }

    public static int getVariant(ObjectID id) {
        CoreArgCheck.isInstanceOf(UUID.class, id, NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.variant();
    }

    public static int getVersion(ObjectID id) {
        CoreArgCheck.isInstanceOf(UUID.class, id, NOT_UUID_MESSAGE);
        UUID uuid = (UUID)id;
        return uuid.uuid.version();
    }

    @Override
    public String getProtocol() {
        return PROTOCOL;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof UUID) {
            UUID that = (UUID)obj;
            return this.uuid.equals(that.uuid);
        }
        return false;
    }

    @Override
    public int compareTo(Object obj) {
        UUID that = (UUID)obj;
        return this.uuid.compareTo(that.uuid);
    }

    @Override
    public String toString() {
        return this.toString(':');
    }

    @Override
    public String toString(char delim) {
        return new StringBuffer(43).append(PROTOCOL).append(delim).append(this.exportableForm()).toString();
    }

    public String exportableForm() {
        if (this.cachedExportableFormUuidString == null) {
            this.cachedExportableFormUuidString = this.uuid.toString();
        }
        return this.cachedExportableFormUuidString;
    }

    public static ObjectID stringToObject(String value) throws InvalidIDException {
        try {
            return new UUID(java.util.UUID.fromString(value));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InvalidIDException(CoreModelerPlugin.Util.getString("UUID.InvalidFormatForProtocol", value, PROTOCOL));
        }
    }

    class Variant {
        public static final int NSC_COMPATIBLE = 0;
        public static final int STANDARD = 2;
        public static final int MICROSOFT = 6;
        public static final int RESERVED_FUTURE = 7;

        Variant() {
        }
    }

    class Version {
        public static final int TIME_BASED = 1;
        public static final int DCE_RESERVED = 2;
        public static final int NAME_BASED = 3;
        public static final int PSEUDO_RANDOM = 4;

        Version() {
        }
    }
}

