/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.util.CoreArgCheck;

public abstract class PluginUtilities {
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String BOOT_PLUGIN_FOLDER = "org.eclipse.core.boot";
    private static final String BOOT_JAR = "boot.jar";
    private static final String PROTOCOL = "file";
    private static final String BOOT_LOADER = "org.eclipse.core.boot.BootLoader";
    private static final String TEMPORARY_METADATA_PATH = String.valueOf(System.getProperty("java.io.tmpdir")) + "metamatrix";
    private static final String STARTUP_METHOD = "startup";
    private static final int BOOT_PLUGIN_FOLDER_NOT_FOUND_CODE = 0;
    private static final String BOOT_PLUGIN_FOLDER_NOT_FOUND_MESSAGE = String.valueOf(CoreModelerPlugin.Util.getString("PluginUtilities.Could_not_find___12", new Object[0])) + "org.eclipse.core.boot" + CoreModelerPlugin.Util.getString("PluginUtilities.__folder._13", new Object[0]);
    private static final String CONSTRUCTOR_MESSAGE = String.valueOf(CoreModelerPlugin.Util.getString("PluginUtilities.Make_sure_the_executable_extension_class_contains_a_public_constructor_14", new Object[0])) + CoreModelerPlugin.Util.getString("PluginUtilities._with_no_arguments._15", new Object[0]);
    private static Class bootLoader;
    private static String[] startupArgs;

    static {
        startupArgs = new String[0];
    }

    public static Object createExecutableExtension(IExtension extension, String element, String attribute) throws CoreException {
        try {
            IConfigurationElement[] elems = extension.getConfigurationElements();
            int ndx = 0;
            int count = elems.length;
            while (ndx < count) {
                IConfigurationElement elem = elems[ndx];
                if (elem.getName().equals(element)) {
                    return elem.createExecutableExtension(attribute);
                }
                ++ndx;
            }
            return null;
        }
        catch (CoreException err) {
            if (err.getStatus().getException() instanceof InstantiationException) {
                System.err.println(CONSTRUCTOR_MESSAGE);
            }
            throw err;
        }
    }

    public static IExtension getExtension(String id, IExtension[] extensions) {
        int ndx = 0;
        int count = extensions.length;
        while (ndx < count) {
            IExtension extension = extensions[ndx];
            String uniqueId = extension.getUniqueIdentifier();
            if (uniqueId != null && uniqueId.equals(id)) {
                return extension;
            }
            ++ndx;
        }
        return null;
    }

    public static IExtension[] getExtensions(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null) {
            IExtensionPoint point = registry.getExtensionPoint(id);
            if (point == null) {
                return new IExtension[0];
            }
            return point.getExtensions();
        }
        return new IExtension[0];
    }

    public static IConfigurationElement[] getConfigurationElementsFor(String id) {
        return Platform.getExtensionRegistry().getConfigurationElementsFor(id);
    }

    public static void startup(String installPath, String metadataPath) throws ClassNotFoundException, CoreException, IllegalAccessException, InvocationTargetException, MalformedURLException, NoSuchMethodException {
        CoreArgCheck.isNotEmpty(installPath, CoreModelerPlugin.Util.getString("PluginUtilities.The_installation_path_must_not_be_empty._18", new Object[0]));
        if (bootLoader == null) {
            StringBuffer bootFolderPath;
            char lastChr;
            if (metadataPath == null) {
                metadataPath = TEMPORARY_METADATA_PATH;
            }
            if ((lastChr = (bootFolderPath = new StringBuffer(installPath)).charAt(bootFolderPath.length() - 1)) != '/' && lastChr != '\\') {
                bootFolderPath.append('/');
            }
            bootFolderPath.append(PLUGINS_FOLDER);
            File[] bootPluginFolders = new File(bootFolderPath.toString()).listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith(PluginUtilities.BOOT_PLUGIN_FOLDER);
                }
            });
            if (bootPluginFolders.length == 0) {
                Status status = new Status(4, BOOT_PLUGIN_FOLDER, 0, BOOT_PLUGIN_FOLDER_NOT_FOUND_MESSAGE, null);
                throw new CoreException((IStatus)status);
            }
            String bootJarPath = new File(bootPluginFolders[0], BOOT_JAR).getAbsolutePath().replace(File.separatorChar, '/');
            URL bootUrl = new URL(PROTOCOL, null, bootJarPath);
            URLClassLoader loader = null;
            try {
                loader = new URLClassLoader(new URL[]{bootUrl}, null);
                Class<?> bootLoader = loader.loadClass(BOOT_LOADER);
                Method startupMeth = bootLoader.getMethod(STARTUP_METHOD, URL.class, String.class, String[].class);
                Object[] objectArray = new Object[3];
                objectArray[1] = metadataPath;
                objectArray[2] = startupArgs;
                startupMeth.invoke(bootLoader, objectArray);
                PluginUtilities.bootLoader = bootLoader;
            }
            catch (Throwable throwable) {
                if (loader != null) {
                    try {
                        loader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (loader != null) {
                try {
                    loader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

