/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.util.Collection;
import java.util.Properties;
import org.teiid.core.designer.CoreModelerPlugin;

public class CoreArgCheck {
    private CoreArgCheck() {
    }

    public static final void isTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static final void isNonNegative(int value) {
        CoreArgCheck.isNonNegative(value, null);
    }

    public static final void isNonNegative(int value, String message) {
        if (value < 0) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isNonNegativeInt", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isPositive(int value) {
        CoreArgCheck.isPositive(value, null);
    }

    public static final void isPositive(int value, String message) {
        if (value <= 0) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isPositiveInt", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotZeroLength(String value) {
        CoreArgCheck.isNotZeroLength(value, null);
    }

    public static final void isNotZeroLength(String value, String message) {
        CoreArgCheck.isNotNull(value);
        if (value.length() <= 0) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isStringNonZeroLength", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotNull(Object value) {
        CoreArgCheck.isNotNull(value, null);
    }

    public static final void isNotNull(Object value, String message) {
        if (value == null) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isNonNull", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isInstanceOf(Class theClass, Object value) {
        CoreArgCheck.isInstanceOf(theClass, value, null);
    }

    public static final void isInstanceOf(Class theClass, Object value, String message) {
        CoreArgCheck.isNotNull(value);
        if (!theClass.isInstance(value)) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isInstanceOf", theClass.getName(), value.getClass().getName());
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotEmpty(Collection collection) {
        CoreArgCheck.isNotEmpty(collection, null);
    }

    public static final void isNotEmpty(Collection collection, String message) {
        CoreArgCheck.isNotNull(collection);
        if (collection.isEmpty()) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isCollectionNotEmpty", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotEmpty(Properties properties) {
        CoreArgCheck.isNotEmpty(properties, null);
    }

    public static final void isNotEmpty(Properties properties, String message) {
        CoreArgCheck.isNotNull(properties);
        if (properties.isEmpty()) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.isPropertiesNotEmpty", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotEmpty(String string) {
        CoreArgCheck.isNotZeroLength(string, null);
    }

    public static final void isNotEmpty(String string, String message) {
        CoreArgCheck.isNotZeroLength(string, message);
    }

    public static final void contains(Collection collection, Object value) {
        CoreArgCheck.contains(collection, value, null);
    }

    public static final void contains(Collection collection, Object value, String message) {
        CoreArgCheck.isNotNull(collection);
        if (!collection.contains(value)) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("CoreArgCheck.contains", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isEqual(boolean value1, boolean value2) {
        CoreArgCheck.isEqual(value1, value2, null);
    }

    public static final void isEqual(boolean value1, boolean value2, String message) {
        if (value1 != value2) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isEqual", new Boolean(value1), new Boolean(value2));
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotEqual(boolean value1, boolean value2) {
        CoreArgCheck.isNotEqual(value1, value2, null);
    }

    public static final void isNotEqual(boolean value1, boolean value2, String message) {
        if (value1 == value2) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isNotEqual", new Boolean(value1), new Boolean(value2));
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isEqual(int value1, int value2) {
        CoreArgCheck.isEqual(value1, value2, null);
    }

    public static final void isEqual(int value1, int value2, String message) {
        if (value1 != value2) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isEqual", new Integer(value1), new Integer(value2));
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isNotEqual(int value1, int value2) {
        CoreArgCheck.isNotEqual(value1, value2, null);
    }

    public static final void isNotEqual(int value1, int value2, String message) {
        if (value1 == value2) {
            String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isNotEqual", new Integer(value1), new Integer(value2));
            throw new IllegalArgumentException(msg);
        }
    }

    public static final void isEqual(Object object1, Object object2) {
        CoreArgCheck.isEqual(object1, object2, null);
    }

    public static final void isEqual(Object object1, Object object2, String message) {
        if (object1 == null) {
            if (object2 != null) {
                String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isEqual", object1, object2);
                throw new IllegalArgumentException(msg);
            }
        } else {
            if (object2 == null) {
                String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isEqual", object1, object2);
                throw new IllegalArgumentException(msg);
            }
            if (!object1.equals(object2)) {
                String msg = message != null ? message : CoreModelerPlugin.Util.getString("Assertion.isEqual", object1, object2);
                throw new IllegalArgumentException(msg);
            }
        }
    }
}

