/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import javax.activation.MimetypesFileTypeMap;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.CoreStringUtil;

public final class FileUtil {
    public static final boolean isArchiveFileName(String name, boolean checkZipExtension) {
        if (name.endsWith(".jar")) {
            return name.length() > ".jar".length();
        }
        if (checkZipExtension) {
            return FileUtil.isZipFileName(name);
        }
        return false;
    }

    public static final boolean isZipFileName(String name) {
        return name.endsWith(".zip") && name.length() > ".zip".length();
    }

    public static String getExtension(File theFile) {
        return FileUtil.getExtension(theFile.getName());
    }

    public static String getExtension(String theFileName) {
        String result = "";
        int index = theFileName.lastIndexOf(46);
        if (index != -1 && index + 1 != theFileName.length()) {
            result = theFileName.substring(index + 1);
        }
        return result;
    }

    public static String readSafe(File file) throws FileNotFoundException {
        String result;
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            result = FileUtil.read(reader);
        }
        catch (Throwable throwable) {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public static String read(Reader reader) {
        StringWriter writer = new StringWriter();
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(reader);
                while (bufferedReader.ready()) {
                    String line = bufferedReader.readLine();
                    writer.write(line);
                    writer.write(CoreStringUtil.LINE_SEPARATOR);
                }
            }
            catch (IOException e) {
                throw new TeiidDesignerRuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        return writer.toString();
    }

    public static String guessFileType(File file) {
        String mimeType = null;
        InputStream mimeTypesStream = FileUtil.class.getResourceAsStream("mime.types");
        MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap(mimeTypesStream);
        mimeType = mimeTypesMap.getContentType(file);
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = mimeTypesMap.getContentType(file.getName());
        if (mimeType != null) {
            return mimeType;
        }
        return mimeType;
    }

    private FileUtil() {
    }

    public static interface Extensions {
        public static final String JAR = ".jar";
        public static final String ZIP = ".zip";
    }
}

