/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.designer.util.StringUtilities;

public final class ModelType
implements Serializable {
    private static final long serialVersionUID = 6569679435239246363L;
    public static final String copyright = "See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.";
    public static final int PHYSICAL = Type.PHYSICAL.getValue();
    public static final int VIRTUAL = Type.VIRTUAL.getValue();
    public static final int TYPE = Type.TYPE.getValue();
    public static final int VDB_ARCHIVE = Type.VDB_ARCHIVE.getValue();
    public static final int UNKNOWN = Type.UNKNOWN.getValue();
    public static final int FUNCTION = Type.FUNCTION.getValue();
    public static final int CONFIGURATION = Type.CONFIGURATION.getValue();
    public static final int METAMODEL = Type.METAMODEL.getValue();
    public static final int EXTENSION = Type.EXTENSION.getValue();
    public static final int LOGICAL = Type.LOGICAL.getValue();
    public static final int MATERIALIZATION = Type.MATERIALIZATION.getValue();

    public static boolean isShredable(int itemType) {
        Type[] enumValues = Type.values();
        if (itemType < 0 || itemType >= enumValues.length) {
            throw new IllegalArgumentException("Unknown model type");
        }
        return enumValues[itemType].isSheddable();
    }

    public static enum Type {
        PHYSICAL(true),
        VIRTUAL(true),
        TYPE(true),
        VDB_ARCHIVE(false),
        UNKNOWN(false),
        FUNCTION(false),
        CONFIGURATION(false),
        METAMODEL(true),
        EXTENSION(true),
        LOGICAL(true),
        MATERIALIZATION(false);

        private final boolean sheddable;
        private static List<String> nameCache;

        private Type(boolean sheddable) {
            this.sheddable = sheddable;
        }

        public boolean isSheddable() {
            return this.sheddable;
        }

        public final String getName() {
            return this.name();
        }

        public final String getCamelCaseName() {
            return StringUtilities.toCamelCase(this.getName());
        }

        public final int getValue() {
            return this.ordinal();
        }

        public final String getLiteral() {
            return this.name();
        }

        public final String toString() {
            return this.name();
        }

        public static List<String> getNames() {
            if (nameCache == null) {
                nameCache = new ArrayList<String>();
                Type[] typeArray = Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type type = typeArray[n2];
                    nameCache.add(type.getName());
                    ++n2;
                }
            }
            return Collections.unmodifiableList(nameCache);
        }

        public static Type getType(String name) {
            name = name.toUpperCase();
            if (!Type.getNames().contains(name)) {
                throw new IllegalArgumentException(String.valueOf(name) + " is an unknown model type");
            }
            return Type.valueOf(name);
        }

        public static int parseString(String name) {
            Type type = Type.getType(name);
            return type.getValue();
        }

        public static Type getType(int index) {
            Type[] enumValues = Type.values();
            if (index < 0 || index >= enumValues.length) {
                throw new IllegalArgumentException(String.valueOf(index) + " denotes an unknown model type");
            }
            return enumValues[index];
        }

        public static String getString(int index) {
            Type type = Type.getType(index);
            return type.getLiteral();
        }
    }
}

