/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.teiid.core.designer.BundleUtil;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.PluginUtil;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;

public class PluginUtilImpl
extends BundleUtil
implements PluginUtil {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(PluginUtilImpl.class);
    private static final String JAVA_VERSION = "java.version";
    private static final String VERSION_DELIMITERS = "._- ";
    public static final String RESOURCE_FILE_ROOT = "i18n";
    public static final String CONFIG = "config";
    private static final String INVALID_JAVA_VERSION_MESSAGE_ID = "invalidJavaVersionMessage";
    private static final String PRODUCT_PROPERTIES = "product.properties";
    private static boolean productPropsLoaded;
    private ILog logger;

    public PluginUtilImpl(String pluginId, String bundleName, ResourceBundle bundle) {
        super(pluginId, bundleName, bundle);
        if (!productPropsLoaded && Platform.isRunning() && Platform.getInstallLocation() != null) {
            try {
                File file = this.getConfigDirectory();
                file = new File(file, PRODUCT_PROPERTIES);
                if (file.exists()) {
                    BundleUtil.productProps = new PropertyResourceBundle(new FileInputStream(file));
                    productPropsLoaded = true;
                }
            }
            catch (Exception theException) {
                this.log(theException);
                BundleUtil.productProps = null;
            }
        }
    }

    public File getConfigDirectory() {
        URL url;
        if (Platform.isRunning() && Platform.getInstallLocation() != null && (url = Platform.getInstallLocation().getURL()) != null) {
            try {
                File parentDir = new File(FileLocator.toFileURL((URL)url).getFile()).getParentFile();
                return new File(parentDir, CONFIG);
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public void initializePlatformLogger(Plugin plugin) {
        this.logger = plugin.getLog();
    }

    @Override
    public void checkJre(String version) throws CoreException {
        String ver = System.getProperty(JAVA_VERSION);
        StringTokenizer verIter = new StringTokenizer(ver, VERSION_DELIMITERS);
        boolean invalid = false;
        StringTokenizer minVerIter = new StringTokenizer(version, VERSION_DELIMITERS);
        while (minVerIter.hasMoreTokens()) {
            int minLvl;
            if (!verIter.hasMoreTokens()) {
                invalid = true;
                break;
            }
            int lvl = Integer.parseInt(verIter.nextToken());
            if (lvl > (minLvl = Integer.parseInt(minVerIter.nextToken()))) {
                return;
            }
            if (lvl >= minLvl) continue;
            invalid = true;
            break;
        }
        if (invalid) {
            String plugin = Platform.getBundle((String)this.pluginId).getSymbolicName();
            String msg = CoreModelerPlugin.Util.getString(String.valueOf(I18N_PREFIX) + INVALID_JAVA_VERSION_MESSAGE_ID, plugin, version, ver);
            Status status = new Status(4, "org.teiid.core.designer", 0, msg, null);
            throw new CoreException((IStatus)status);
        }
    }

    @Override
    public void log(IStatus status) {
        this.logger.log(status);
    }

    @Override
    public void log(int severity, String message) {
        this.logger.log((IStatus)new Status(severity, this.pluginId, message));
    }

    @Override
    public void log(int severity, Throwable t, String message) {
        this.logger.log((IStatus)new Status(severity, this.pluginId, message, t));
    }

    @Override
    public void log(Object obj) {
        if (obj != null) {
            this.log(2, obj.toString());
        }
    }

    @Override
    public void log(Throwable throwable) {
        this.log(4, throwable, throwable.getLocalizedMessage());
    }

    String getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getString(String key, Object parameter) {
        if (parameter != null) {
            if (parameter.getClass().isArray()) {
                return this.getString(key, (Object[])parameter);
            }
            if (parameter instanceof List) {
                return this.getString(key, (List)parameter);
            }
        }
        return this.getString(key, new Object[]{parameter});
    }

    protected class DefaultRunner {
        protected DefaultRunner() {
        }

        public void run(ISafeRunnable code) {
            CoreArgCheck.isNotNull(code);
            try {
                code.run();
            }
            catch (Exception e) {
                this.handleException(code, e);
            }
            catch (LinkageError e) {
                this.handleException(code, e);
            }
        }

        private void handleException(ISafeRunnable code, Throwable e) {
            if (!(e instanceof OperationCanceledException)) {
                String pluginId = PluginUtilImpl.this.getPluginId();
                String message = PluginUtilImpl.this.getString("PluginUtilImpl.Error_while_running", (Object)pluginId);
                MultiStatus status = null;
                if (e instanceof CoreException) {
                    status = new MultiStatus(pluginId, 2, message, e);
                    status.merge(((CoreException)e).getStatus());
                } else {
                    status = new Status(4, pluginId, 2, message, e);
                }
                PluginUtilImpl.this.log((IStatus)status);
            }
            code.handleException(e);
        }
    }

    protected class PlatformRunner
    extends DefaultRunner {
        protected PlatformRunner() {
        }

        @Override
        public void run(final ISafeRunnable code) {
            ISafeRunnable wrapper = new ISafeRunnable(){

                public void handleException(Throwable exception) {
                    String message = PluginUtilImpl.this.getString("PluginUtilImpl.Error_while_running", (Object)PluginUtilImpl.this.getPluginId());
                    PluginUtilImpl.this.log(4, message);
                    code.handleException(exception);
                }

                public void run() throws Exception {
                    SafeRunner.run((ISafeRunnable)code);
                }
            };
            SafeRunner.run((ISafeRunnable)wrapper);
        }
    }
}

