/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.Serializable;
import org.teiid.core.designer.CoreModelerPlugin;
import org.teiid.core.designer.util.CoreStringUtil;

public class Stopwatch
implements Serializable {
    private static final long serialVersionUID = 8632873770474816540L;
    private long start = 0L;
    private long stop = 0L;
    private Statistics stats = new Statistics();
    private boolean active = true;
    private static final String SECONDS = CoreModelerPlugin.Util.getString("Stopwatch.seconds", new Object[0]);
    private static final String MILLISECONDS = CoreModelerPlugin.Util.getString("Stopwatch.milliseconds", new Object[0]);
    private static final int VALUE_LENGTH = 10;

    public boolean isActive() {
        return this.active;
    }

    public void start() {
        if (this.active) {
            this.start = System.currentTimeMillis();
        }
    }

    public void start(boolean reset) {
        if (reset) {
            this.reset();
        }
        this.start();
    }

    public void stop() {
        if (this.active) {
            this.stop = System.currentTimeMillis();
            this.stats.add(this.stop - this.start);
        }
    }

    public void reset() {
        this.start = 0L;
        this.stop = 0L;
        this.stats.reset();
    }

    public long getTotalDuration() {
        return this.stats.getTotal();
    }

    public float getAverageDuration() {
        return this.stats.getAverage();
    }

    public int getSegmentCount() {
        return this.stats.getCount();
    }

    public String toString() {
        String units = MILLISECONDS;
        StringBuffer valueString = null;
        long value = this.getTotalDuration();
        if (value >= 1000L) {
            float fvalue = (float)value / 1000.0f;
            units = SECONDS;
            valueString = new StringBuffer(Float.toString(fvalue));
        } else {
            valueString = new StringBuffer(Long.toString(value));
        }
        valueString.append(units);
        return valueString.toString();
    }

    public String getTimeValueAsString(long value) {
        String units = MILLISECONDS;
        StringBuffer valueString = null;
        if (value >= 1000L) {
            float fvalue = (float)value / 1000.0f;
            units = SECONDS;
            valueString = new StringBuffer(Float.toString(fvalue));
        } else {
            valueString = new StringBuffer(Long.toString(value));
        }
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return valueString + units;
    }

    public String getTimeValueAsString(float value) {
        String units = MILLISECONDS;
        if (value >= 1000.0f) {
            value /= 1000.0f;
            units = SECONDS;
        }
        StringBuffer valueString = new StringBuffer(Float.toString(value));
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return valueString + units;
    }

    public String getValueAsString(int value) {
        StringBuffer valueString = new StringBuffer(Integer.toString(value));
        while (valueString.length() < 10) {
            valueString.insert(0, ' ');
        }
        return "" + valueString;
    }

    public static void logTimedMessage(String message, long time) {
        CoreModelerPlugin.Util.log(1, String.valueOf(Stopwatch.getTimeString(time)) + message);
    }

    public void stopLogIncrementAndRestart(String message) {
        this.stop();
        Stopwatch.logTimedMessage(message, this.getTotalDuration());
        this.start(true);
    }

    private static String getTimeString(long time) {
        String timeString = "" + time;
        int nSpaces = 8 - timeString.length();
        StringBuffer buff = new StringBuffer();
        buff.append("Time = [");
        int i = 0;
        while (i < nSpaces) {
            buff.append(CoreStringUtil.Constants.SPACE);
            ++i;
        }
        buff.append(String.valueOf(timeString) + "] ms : ");
        return buff.toString();
    }

    public class Statistics
    implements Serializable {
        private static final long serialVersionUID = 6451257438010489623L;
        private long minimum = 0L;
        private long maximum = 0L;
        private long last = 0L;
        private long total = 0L;
        private int count = 0;
        private boolean minimumInitialized = false;

        public long getMinimum() {
            return this.minimum;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getLast() {
            return this.last;
        }

        public float getAverage() {
            return (float)this.total / (float)this.count;
        }

        public long getTotal() {
            return this.total;
        }

        public int getCount() {
            return this.count;
        }

        public void add(long duration) {
            ++this.count;
            this.total += duration;
            this.last = duration;
            if (duration > this.maximum) {
                this.maximum = duration;
            } else if (!this.minimumInitialized || duration < this.minimum) {
                this.minimum = duration;
                this.minimumInitialized = true;
            }
        }

        public void reset() {
            this.minimum = 0L;
            this.maximum = 0L;
            this.last = 0L;
            this.total = 0L;
            this.count = 0;
            this.minimumInitialized = false;
        }
    }
}

