/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.designer.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.teiid.core.designer.TeiidDesignerRuntimeException;
import org.teiid.core.designer.util.StringConstants;

public class StringUtilities
implements StringConstants {
    public static String buildPath(String prefix, String suffix) {
        StringBuffer path = new StringBuffer(prefix);
        if (!prefix.endsWith(File.separator)) {
            path.append(File.separator);
        }
        if (suffix.startsWith(File.separator)) {
            path.append(suffix.substring(File.separator.length()));
        } else {
            path.append(suffix);
        }
        return path.toString();
    }

    public static String condenseToLength(String originalString, int maxLength, int endLength, String middleString) {
        if (originalString.length() <= maxLength) {
            return originalString;
        }
        int originalLength = originalString.length();
        StringBuffer sb = new StringBuffer(maxLength);
        sb.append(originalString.substring(0, maxLength - endLength - middleString.length()));
        sb.append(middleString);
        sb.append(originalString.substring(originalLength - endLength, originalLength));
        return sb.toString();
    }

    public static boolean areDifferent(String string1, String string2) {
        if (string1 == null) {
            return string2 != null;
        }
        return !string1.equals(string2);
    }

    public static boolean equals(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equals(string2);
    }

    public static boolean equalsIgnoreCase(String string1, String string2) {
        if (string1 == null) {
            return string2 == null;
        }
        return string1.equalsIgnoreCase(string2);
    }

    public static String getLastUpperCharToken(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = value.length() - 1;
        while (i >= 0) {
            result.insert(0, value.charAt(i));
            if (Character.isUpperCase(value.charAt(i))) {
                return result.toString();
            }
            --i;
        }
        return result.toString();
    }

    public static String getLastUpperCharToken(String value, String lastToken) {
        if (value == null || lastToken == null) {
            return value;
        }
        int index = value.lastIndexOf(lastToken);
        if (index == -1) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = index - 1;
        while (i >= 0) {
            result.insert(0, value.charAt(i));
            if (Character.isUpperCase(value.charAt(i))) {
                return String.valueOf(result.toString()) + lastToken;
            }
            --i;
        }
        return String.valueOf(result.toString()) + lastToken;
    }

    public static String[] getLines(String value) {
        StringReader stringReader = new StringReader(value);
        BufferedReader reader = new BufferedReader(stringReader);
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line = reader.readLine();
            while (line != null) {
                result.add(line);
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new TeiidDesignerRuntimeException(e);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNotEmpty(String text) {
        return text != null && text.trim().length() > 0;
    }

    public static String lowerCaseFirstChar(String value) {
        if (value == null) {
            return null;
        }
        String firstChar = new Character(value.charAt(0)).toString();
        firstChar = firstChar.toLowerCase();
        return String.valueOf(firstChar) + value.substring(1);
    }

    public static String[] parseCommaDelimitedString(String csvString) {
        String[] result = StringUtilities.parseList(csvString, ",");
        int i = 0;
        while (i < result.length) {
            result[i] = result[i].trim();
            ++i;
        }
        return result;
    }

    public static String[] parseList(String delimitedString, String delimiter) {
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(delimitedString, delimiter);
        while (tokenizer.hasMoreTokens()) {
            result.add(tokenizer.nextToken());
        }
        return result.toArray(new String[0]);
    }

    public static String removeChars(String value, char[] chars) {
        StringBuffer result = new StringBuffer();
        if (value != null && chars != null && chars.length > 0) {
            String removeChars = String.valueOf(chars);
            int i = 0;
            while (i < value.length()) {
                String character = value.substring(i, i + 1);
                if (removeChars.indexOf(character) == -1) {
                    result.append(character);
                }
                ++i;
            }
        } else {
            result.append(value);
        }
        return result.toString();
    }

    public static String removeExtraWhitespace(String value) {
        return value.replaceAll("\\s\\s+", " ");
    }

    public static String replaceWhitespace(String value, boolean stripExtras) {
        return StringUtilities.replaceWhitespace(value, " ", stripExtras);
    }

    public static String replaceWhitespace(String value, String replaceWith, boolean stripExtras) {
        String rv = value.replaceAll("\\s+", replaceWith);
        if (stripExtras) {
            rv = StringUtilities.removeExtraWhitespace(rv);
        }
        return rv;
    }

    public static String upperCaseFirstChar(String value) {
        if (value == null) {
            return null;
        }
        String firstChar = new Character(value.charAt(0)).toString();
        firstChar = firstChar.toUpperCase();
        return String.valueOf(firstChar) + value.substring(1);
    }

    public static String toCamelCase(String value) {
        StringBuffer sb = new StringBuffer();
        String[] stringArray = value.split("_");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sb.append(Character.toUpperCase(s.charAt(0)));
            if (s.length() > 1) {
                sb.append(s.substring(1, s.length()).toLowerCase());
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String fromCamelCase(String value) {
        if (value == null) {
            return "";
        }
        String regexp = String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])");
        return value.replaceAll(regexp, " ");
    }

    public static String getUniqueName(String baseName, Set<String> otherNames, boolean appendInteger, boolean appendWithSpace, int countLimit) {
        int count = 1;
        String newName = baseName;
        newName = appendWithSpace ? String.valueOf(baseName) + " " + count : String.valueOf(baseName) + count;
        if (otherNames.contains(newName)) {
            newName = appendWithSpace ? String.valueOf(baseName) + " " + count : String.valueOf(baseName) + count;
            while (count < countLimit) {
                if (!otherNames.contains(newName)) {
                    return newName;
                }
                newName = String.valueOf(baseName) + " " + ++count;
            }
        } else {
            return newName;
        }
        return baseName;
    }

    public static boolean isLetter(char c) {
        return StringUtilities.isBasicLatinLetter(c) || Character.isLetter(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return StringUtilities.isBasicLatinLetter(c) || StringUtilities.isBasicLatinDigit(c) || Character.isLetterOrDigit(c);
    }

    public static boolean isBlank(String text) {
        return text == null || text.trim().length() == 0;
    }

    public static boolean isNumber(String text) {
        return !StringUtilities.isBlank(text) && text.matches("-?\\d+(\\.\\d+)?");
    }

    private static boolean isBasicLatinLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isBasicLatinDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static String replaceAll(String source, String search, String replace) {
        int start;
        if (source != null && search != null && search.length() > 0 && replace != null && (start = source.indexOf(search)) > -1) {
            StringBuffer newString = new StringBuffer(source);
            StringUtilities.replaceAll(newString, search, replace);
            return newString.toString();
        }
        return source;
    }

    public static void replaceAll(StringBuffer source, String search, String replace) {
        if (source != null && search != null && search.length() > 0 && replace != null) {
            int start = source.toString().indexOf(search);
            while (start > -1) {
                int end = start + search.length();
                source.replace(start, end, replace);
                start = source.toString().indexOf(search, start + replace.length());
            }
        }
    }

    public static void main(String[] args) {
        String startName = "XXXXX";
        HashSet<String> otherNames = new HashSet<String>();
        otherNames.add("XXXXX");
        otherNames.add("YYYYY");
        String newName = StringUtilities.getUniqueName(startName, otherNames, true, true, 1000);
        System.out.println("  START NAME = " + startName + " UNIQUE NAME = " + newName);
        otherNames.add("XXXXX 1");
        newName = StringUtilities.getUniqueName(startName, otherNames, true, true, 1000);
        System.out.println("  START NAME = " + startName + " UNIQUE NAME = " + newName);
        otherNames.add("XXXXX 2");
        newName = StringUtilities.getUniqueName(startName, otherNames, true, true, 1000);
        System.out.println("  START NAME = " + startName + " UNIQUE NAME = " + newName);
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int prefixLength(char[] s1, char[] s2) {
        int len = 0;
        int max = Math.min(s1.length, s2.length);
        int i = 0;
        while (i < max && s1[i] == s2[i]) {
            ++len;
            ++i;
        }
        return len;
    }

    public static int prefixLength(String s1, String s2) {
        int len = 0;
        int max = Math.min(s1.length(), s2.length());
        int i = 0;
        while (i < max && s1.charAt(i) == s2.charAt(i)) {
            ++len;
            ++i;
        }
        return len;
    }

    public static String removeXmiExtension(String input) {
        if (input.toUpperCase().endsWith(".XMI")) {
            return input.substring(0, input.length() - 4);
        }
        return input;
    }

    public static String getQuotedValue(String value, String quoteStr) {
        if (value.length() > 3 && value.startsWith(quoteStr) && value.endsWith(quoteStr)) {
            return value;
        }
        String quotedValue = String.valueOf(quoteStr) + value + quoteStr;
        return quotedValue;
    }

    public static boolean isSingleQuoted(String value) {
        return value.length() > 1 && value.startsWith("'") && value.endsWith("'");
    }

    private StringUtilities() {
    }
}

