/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug;

import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.model.IBreakpoint;
import org.fusesource.ide.camel.model.service.core.model.CamelFile;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public final class MarkerNodeIDUpdateEventhandler
implements EventHandler {
    public void handleEvent(Event event) {
        String oldId = (String)event.getProperty("OLD_ID");
        String newId = (String)event.getProperty("NEW_ID");
        CamelFile camelFile = (CamelFile)event.getProperty("CAMEL_FILE");
        this.updateBreakpoint(newId, oldId, camelFile);
    }

    private void updateBreakpoint(String newId, String oldId, CamelFile camelFile) {
        IBreakpoint breakpointForSelection = this.getBreakpoint(oldId, camelFile);
        if (breakpointForSelection != null && breakpointForSelection instanceof CamelEndpointBreakpoint) {
            ((CamelEndpointBreakpoint)breakpointForSelection).updateEndpointNodeId(newId);
        }
    }

    private IBreakpoint getBreakpoint(String oldId, CamelFile camelFile) {
        IResource resource = camelFile.getResource();
        return CamelDebugUtils.getBreakpointForSelection(oldId, resource.getName(), resource.getProject().getName());
    }
}

