/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.launching;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceLookupParticipant;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.jdt.launching.sourcelookup.containers.JavaSourceLookupParticipant;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.fusesource.ide.foundation.ui.io.CamelXMLEditorInput;
import org.fusesource.ide.launcher.debug.launching.CamelSourceLookupParticipant;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class CamelSourceLookupDirector
extends AbstractSourceLookupDirector
implements ISourcePresentation {
    public void initializeParticipants() {
        ISourceLookupParticipant[] participants = new ISourceLookupParticipant[]{new CamelSourceLookupParticipant(), new JavaSourceLookupParticipant()};
        this.addParticipants(participants);
    }

    public IEditorInput getEditorInput(Object element) {
        IEditorInput input = null;
        if (element instanceof LocalFileStorage) {
            LocalFileStorage lfs = (LocalFileStorage)element;
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                IFile f = (IFile)entry.getEditorInput().getAdapter(IFile.class);
                if (!f.getLocation().toFile().getPath().equals(lfs.getFile().getPath())) continue;
                input = entry.getEditorInput();
                break;
            }
            return input;
        }
        if (element instanceof File) {
            File sourceFile = (File)element;
            if (sourceFile.getName().toLowerCase().endsWith(".java")) {
                IProject prj = CamelDebugUtils.getProjectForFilePath(sourceFile.getPath());
                IPath fp = prj.findMember(sourceFile.getPath()).getFullPath();
                IFile sourceFileResolved = prj.getFile(fp);
                return new FileEditorInput(sourceFileResolved);
            }
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                IFile f = (IFile)entry.getEditorInput().getAdapter(IFile.class);
                if (!f.getLocation().toFile().getName().equals(sourceFile.getName())) continue;
                input = entry.getEditorInput();
                break;
            }
            return input;
        }
        if (element instanceof IFile) {
            IFile sourceFile = (IFile)element;
            if (sourceFile.getName().toLowerCase().endsWith(".java")) {
                return new FileEditorInput(sourceFile);
            }
            for (CamelDebugRegistryEntry entry : CamelDebugRegistry.getInstance().getEntries().values()) {
                IFile f = ((CamelXMLEditorInput)entry.getEditorInput()).getCamelContextFile();
                if (f == null || !f.getFullPath().equals((Object)sourceFile.getFullPath())) continue;
                input = entry.getEditorInput();
                break;
            }
            return input;
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        if (input instanceof FileEditorInput) {
            return "org.eclipse.jdt.ui.CompilationUnitEditor";
        }
        return "org.fusesource.ide.camel.editor";
    }
}

