/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.fusesource.ide.camel.model.service.core.model.AbstractCamelModelElement;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistry;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class CamelConditionalBreakpoint
extends CamelEndpointBreakpoint {
    protected String language;
    protected String conditionPredicate;

    public CamelConditionalBreakpoint() {
    }

    public CamelConditionalBreakpoint(IResource resource, AbstractCamelModelElement endpoint, String projectName, String fileName, String language, String conditionPredicate) throws CoreException {
        this.endpointNodeId = endpoint.getId();
        this.contextId = endpoint.getCamelContext().getId();
        this.projectName = projectName;
        this.fileName = fileName;
        this.language = language;
        this.conditionPredicate = conditionPredicate;
        if (resource.getLocation().toFile().getPath().indexOf(String.format("%s%s%starget%s", Character.valueOf(File.separatorChar), projectName, Character.valueOf(File.separatorChar), Character.valueOf(File.separatorChar))) != -1) {
            for (ILaunchConfiguration lc : CamelDebugRegistry.getInstance().getEntries().keySet()) {
                CamelDebugRegistryEntry entry = CamelDebugRegistry.getInstance().getEntry(lc);
                if (!((IFile)entry.getEditorInput().getAdapter(IFile.class)).getFullPath().toFile().getPath().equals(resource.getFullPath().toFile().getPath())) continue;
                this.resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(lc)));
            }
        } else {
            this.resource = resource;
        }
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = CamelConditionalBreakpoint.this.resource.createMarker("org.fusesource.ide.launcher.debug.camel.conditionalbreakpoint.marker");
                marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                marker.setAttribute("org.eclipse.debug.core.persisted", (Object)Boolean.TRUE);
                marker.setAttribute("org.eclipse.debug.core.id", (Object)CamelConditionalBreakpoint.this.getModelIdentifier());
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.contextid", (Object)CamelConditionalBreakpoint.this.contextId);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.endpointid", (Object)CamelConditionalBreakpoint.this.endpointNodeId);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.projectname", (Object)CamelConditionalBreakpoint.this.projectName);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.filename", (Object)CamelConditionalBreakpoint.this.fileName);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.language", (Object)CamelConditionalBreakpoint.this.language);
                marker.setAttribute("org.fusesource.ide.launcher.debug.marker.condition", (Object)CamelConditionalBreakpoint.this.conditionPredicate);
                marker.setAttribute("message", (Object)("Camel Breakpoint: " + CamelConditionalBreakpoint.this.resource.getName() + " [Endpoint: " + CamelConditionalBreakpoint.this.endpointNodeId + "]"));
                CamelConditionalBreakpoint.this.setMarker(marker);
            }
        };
        this.run(this.getMarkerRule(this.resource), runnable);
        this.setPersisted(true);
    }

    @Override
    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.projectName = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.projectname", this.projectName);
        this.endpointNodeId = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.endpointid", this.endpointNodeId);
        this.fileName = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.filename", this.fileName);
        this.contextId = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.contextid", this.contextId);
        this.language = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.language", this.language);
        this.conditionPredicate = marker.getAttribute("org.fusesource.ide.launcher.debug.marker.condition", this.conditionPredicate);
        this.resource = marker.getResource();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getConditionPredicate() {
        return this.conditionPredicate;
    }

    public void setConditionPredicate(String conditionPredicate) {
        this.conditionPredicate = conditionPredicate;
    }

    @Override
    public String toString() {
        return String.format("Camel Conditional Breakpoint [endpointId=%s, project=%s, fileName=%s, contextId=%s, language=%s, condition=%s]", this.getEndpointNodeId(), this.getProjectName(), this.getFileName(), this.getContextId(), this.getLanguage(), this.getConditionPredicate());
    }
}

