/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.camel.model.service.core.jmx.camel.IBacklogTracerMessage;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.jmx.commons.backlogtracermessage.Message;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelThread;
import org.fusesource.ide.launcher.debug.model.values.BaseCamelValue;
import org.fusesource.ide.launcher.debug.model.values.CamelDebuggerValue;
import org.fusesource.ide.launcher.debug.model.values.CamelExchangeValue;
import org.fusesource.ide.launcher.debug.model.values.CamelMessageValue;
import org.fusesource.ide.launcher.debug.model.values.CamelProcessorValue;
import org.fusesource.ide.launcher.debug.model.variables.BaseCamelVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelDebuggerVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelExchangeVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelMessageVariable;
import org.fusesource.ide.launcher.debug.model.variables.CamelProcessorVariable;
import org.fusesource.ide.launcher.debug.model.variables.IVariableConstants;

public class CamelStackFrame
extends CamelDebugElement
implements IStackFrame,
IVariableConstants {
    private CamelThread fThread;
    private CamelDebugTarget debugTarget;
    private int fId;
    private ArrayList<IVariable> fVariables = new ArrayList();
    private String data;
    private File contextFile;
    private BacklogTracerEventMessage backlogTracerEventMessage;

    public CamelStackFrame(CamelThread thread, String data, int id, File f, BacklogTracerEventMessage msg) {
        super((CamelDebugTarget)thread.getDebugTarget());
        this.data = data;
        this.fId = id;
        this.contextFile = f;
        this.debugTarget = (CamelDebugTarget)thread.getDebugTarget();
        this.fThread = thread;
        this.backlogTracerEventMessage = msg;
        try {
            this.initVariables();
        }
        catch (DebugException ex) {
            Activator.getLogger().error((Throwable)ex);
        }
    }

    private void initVariables() throws DebugException {
        BaseCamelVariable var = null;
        BaseCamelValue val = null;
        var = new CamelDebuggerVariable(this.debugTarget, "CamelDebugger", String.class);
        val = new CamelDebuggerValue(this.fTarget, this, var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new BaseCamelVariable(this.debugTarget, "Endpoint", String.class);
        val = new BaseCamelValue(this.fTarget, this.getEndpointId(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelProcessorVariable(this.debugTarget, "Processor", String.class);
        val = new CamelProcessorValue(this.fTarget, this, this.getEndpointId(), var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelExchangeVariable(this.debugTarget, "Exchange", String.class);
        val = new CamelExchangeValue(this.fTarget, this.backlogTracerEventMessage, var.getReferenceType());
        var.setValue(val);
        this.fVariables.add(var);
        var = new CamelMessageVariable(this.debugTarget, "Message", Message.class);
        val = new CamelMessageValue(this.fTarget, (IBacklogTracerMessage)this.backlogTracerEventMessage.getMessage(), var.getReferenceType(), (CamelMessageVariable)var);
        var.setValue(val);
        this.fVariables.add(var);
    }

    public void updateChangedFieldsFromLastStack(CamelStackFrame lastStackFrame) throws DebugException {
        this.updateChangedFields(lastStackFrame.getVariables(), this.getVariables());
    }

    private void updateChangedFields(IVariable[] oldVariables, IVariable[] newVariables) throws DebugException {
        IVariable[] iVariableArray = newVariables;
        int n = newVariables.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable nV = iVariableArray[n2];
            BaseCamelVariable newVar = (BaseCamelVariable)nV;
            IVariable[] iVariableArray2 = oldVariables;
            int n3 = oldVariables.length;
            int n4 = 0;
            while (n4 < n3) {
                IVariable oldVar = iVariableArray2[n4];
                if (newVar.getName().equals(oldVar.getName())) {
                    IValue oldValue = oldVar.getValue();
                    IValue newValue = newVar.getValue();
                    if (!oldValue.getValueString().equals(newValue.getValueString())) {
                        newVar.markChanged();
                    }
                    if (newValue.hasVariables() && oldValue.hasVariables()) {
                        this.updateChangedFields(oldValue.getVariables(), newValue.getVariables());
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public String getEndpointId() {
        return this.data;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() throws DebugException {
        return this.fVariables.toArray(new IVariable[this.fVariables.size()]);
    }

    public boolean hasVariables() throws DebugException {
        return !this.fVariables.isEmpty();
    }

    public int getLineNumber() throws DebugException {
        return -1;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        if (this.backlogTracerEventMessage != null) {
            return String.format("%s in %s [%s]", this.backlogTracerEventMessage.getToNode(), this.backlogTracerEventMessage.getRouteId(), this.contextFile != null ? this.contextFile.getName() : "unknown");
        }
        return this.contextFile != null ? String.valueOf(this.contextFile.getName()) + ": " + this.data : this.data;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public BacklogTracerEventMessage getBacklogTracerEventMessage() {
        return this.backlogTracerEventMessage;
    }

    protected int getIdentifier() {
        return this.fId;
    }

    public File getContextFile() {
        return this.contextFile;
    }

    public String getSource() {
        return this.contextFile != null ? this.contextFile.getName() : null;
    }

    public CamelDebugFacade getDebugger() {
        return ((CamelDebugTarget)this.getDebugTarget()).getDebugger();
    }
}

