/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.fusesource.ide.jmx.commons.backlogtracermessage.BacklogTracerEventMessage;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelDebugFacade;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.CamelEndpointBreakpoint;
import org.fusesource.ide.launcher.debug.model.CamelStackFrame;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;

public class CamelThread
extends CamelDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private ArrayList<CamelStackFrame> stackFrames = new ArrayList();
    private boolean fStepping = false;
    private String name;
    private boolean suspended = false;
    private boolean terminated = false;
    private long lastSuspended = -1L;
    private String uniqueId;

    public CamelThread(CamelDebugTarget target, String uniqueId) {
        super(target);
        this.uniqueId = uniqueId;
        this.fireCreationEvent();
        this.setName(this.uniqueId);
    }

    public void breakpointHit(String nodeId, BacklogTracerEventMessage msg) {
        File f = null;
        try {
            try {
                String file = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(this.getLaunch().getLaunchConfiguration());
                if (file != null) {
                    f = new File(file);
                }
                CamelStackFrame lastStack = this.stackFrames.isEmpty() ? null : this.stackFrames.get(0);
                CamelStackFrame newStack = new CamelStackFrame(this, nodeId, (String.valueOf(msg.getExchangeId()) + "@" + nodeId + "@" + msg.getRouteId()).hashCode(), f, msg);
                if (lastStack != null) {
                    newStack.updateChangedFieldsFromLastStack(lastStack);
                }
                this.stackFrames.add(0, newStack);
            }
            catch (Exception ex) {
                Activator.getLogger().error((Throwable)ex);
                try {
                    this.suspend();
                }
                catch (DebugException ex2) {
                    Activator.getLogger().error((Throwable)ex2);
                }
            }
        }
        finally {
            try {
                this.suspend();
            }
            catch (DebugException ex) {
                Activator.getLogger().error((Throwable)ex);
            }
        }
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return this.stackFrames.toArray(new IStackFrame[this.stackFrames.size()]);
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended() && this.stackFrames.size() > 0;
    }

    public int getPriority() throws DebugException {
        return 5;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        if (this.stackFrames.size() > 0) {
            return this.stackFrames.get(0);
        }
        return null;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
        this.fireChangeEvent(256);
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new CamelEndpointBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    public long getLastSuspended() {
        return this.lastSuspended;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        if (!this.fStepping) {
            ((CamelDebugTarget)this.getDebugTarget()).getDebugger().resumeBreakpoint(((CamelStackFrame)this.getTopStackFrame()).getEndpointId());
            this.fireResumeEvent(32);
        } else {
            this.fireResumeEvent(2);
        }
        this.suspended = false;
        this.lastSuspended = System.currentTimeMillis();
        this.fireChangeEvent(512);
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.suspended = true;
        this.fireChangeEvent(512);
        if (this.fStepping) {
            this.fireSuspendEvent(8);
            this.fStepping = false;
        } else {
            this.fireSuspendEvent(16);
        }
        this.fireChangeEvent(256);
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
        CamelDebugFacade debugger = ((CamelDebugTarget)this.getDebugTarget()).getDebugger();
        String endpointId = ((CamelStackFrame)this.getTopStackFrame()).getEndpointId();
        try {
            this.fStepping = true;
            if (!debugger.isSingleStepMode()) {
                debugger.stepBreakpoint(endpointId);
            } else {
                debugger.step();
            }
        }
        finally {
            this.resume();
        }
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated = true;
        this.fireTerminateEvent();
    }
}

