/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.model.values;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.fusesource.ide.launcher.debug.model.CamelDebugElement;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.model.variables.IVariableConstants;

public class BaseCamelValue
extends CamelDebugElement
implements IValue,
IVariableConstants {
    private String fValue;
    private Class<?> fType;

    public BaseCamelValue(CamelDebugTarget target, String value, Class<?> type) {
        super(target);
        this.fValue = value;
        this.fType = type;
    }

    public String getReferenceTypeName() throws DebugException {
        return String.format("%s (id=%d)", this.getVariableDisplayString(), this.getVariableIDCode());
    }

    protected int getVariableIDCode() throws DebugException {
        return this.fValue.hashCode();
    }

    protected String getVariableDisplayString() {
        return this.fType.getName();
    }

    public String getValueString() throws DebugException {
        if (this.hasVariables()) {
            return this.getReferenceTypeName();
        }
        return this.fValue;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        return new IVariable[0];
    }

    public boolean hasVariables() throws DebugException {
        return false;
    }
}

