/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.debug.util;

import java.util.HashMap;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.ui.IEditorInput;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.debug.util.CamelDebugRegistryEntry;

public final class CamelDebugRegistry {
    private static HashMap<ILaunchConfiguration, CamelDebugRegistryEntry> entries = new HashMap();
    private static CamelDebugRegistry instance;

    public static synchronized CamelDebugRegistry getInstance() {
        if (instance == null) {
            instance = new CamelDebugRegistry();
        }
        return instance;
    }

    public void createEntry(CamelDebugTarget debugTarget, String fileName, IEditorInput editorInput, ILaunchConfiguration launchConfig) {
        entries.put(launchConfig, new CamelDebugRegistryEntry(debugTarget, fileName, editorInput, launchConfig));
    }

    public CamelDebugRegistryEntry getEntry(ILaunchConfiguration launchConfig) {
        return entries.get(launchConfig);
    }

    public void removeEntry(ILaunchConfiguration launchConfig) {
        entries.remove(launchConfig);
    }

    public HashMap<ILaunchConfiguration, CamelDebugRegistryEntry> getEntries() {
        HashMap<ILaunchConfiguration, CamelDebugRegistryEntry> copy = new HashMap<ILaunchConfiguration, CamelDebugRegistryEntry>();
        copy.putAll(entries);
        return copy;
    }
}

