/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.run.launching;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.fusesource.ide.foundation.core.util.CamelUtils;
import org.fusesource.ide.launcher.debug.util.CamelDebugUtils;
import org.fusesource.ide.launcher.run.launching.FuseMavenLaunchDelegate;
import org.fusesource.ide.launcher.run.util.MavenLaunchUtils;

public class CamelRunMavenLaunchDelegate
extends FuseMavenLaunchDelegate {
    public CamelRunMavenLaunchDelegate() {
        super("clean package");
    }

    @Override
    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        IFile pomFile = null;
        String newGoalsAdditionForFile = null;
        String filePath = CamelDebugUtils.getRawCamelContextFilePathFromLaunchConfig(configuration);
        if (filePath.trim().length() > 0) {
            IFile f;
            boolean isBluePrint = CamelUtils.isBlueprintFile((String)filePath);
            if (filePath.trim().length() > 0) {
                newGoalsAdditionForFile = String.format(" -D%s=\"file:%s\"", "camel.fileApplicationContextUri", filePath);
                if (isBluePrint) {
                    newGoalsAdditionForFile = String.format("%s -D%s", newGoalsAdditionForFile, "camel.blueprint=true");
                }
            }
            if ((f = this.getFileInWorkspace(filePath)) != null) {
                IProject p = f.getProject();
                pomFile = p.getFile("pom.xml");
            }
        }
        if (this.isWarPackaging(pomFile)) {
            this.setGoals("clean package org.eclipse.jetty:jetty-maven-plugin:run");
        } else {
            this.setGoals("clean package org.apache.camel:camel-maven-plugin:run");
        }
        return String.valueOf(super.getGoals(configuration)) + newGoalsAdditionForFile;
    }

    protected boolean isWarPackaging(IFile pomFile) throws CoreException {
        return MavenLaunchUtils.isPackagingTypeWAR(pomFile);
    }

    protected IFile getFileInWorkspace(String filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)filePath));
    }

    @Override
    public String getEclipseProcessName() {
        return "Local Camel Context";
    }
}

