/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.run.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.m2e.internal.launch.MavenLaunchDelegate;
import org.fusesource.ide.launcher.Activator;
import org.fusesource.ide.launcher.debug.model.CamelDebugTarget;
import org.fusesource.ide.launcher.util.SecureStorageUtil;

public abstract class FuseMavenLaunchDelegate
extends MavenLaunchDelegate {
    protected String goals = "";
    protected boolean skipTests = false;

    public FuseMavenLaunchDelegate(String goals) {
        this.goals = goals;
    }

    protected String getGoals(ILaunchConfiguration configuration) throws CoreException {
        return this.goals;
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.launch(configuration, mode, launch, monitor);
        if (mode.equals("debug") && launch.getProcesses() != null && launch.getProcesses().length > 0) {
            String jmxUrl = configuration.getAttribute("org.fusesource.ide.launcher.debug.jmx.uri", "service:jmx:rmi:///jndi/rmi://localhost:1099/jmxrmi/camel");
            String jmxUser = configuration.getAttribute("org.fusesource.ide.launcher.debug.jmx.user", "");
            String jmxPass = this.getPassword(configuration);
            IProcess p = launch.getProcesses()[0];
            CamelDebugTarget target = new CamelDebugTarget(launch, p, jmxUrl, jmxUser, jmxPass);
            launch.addDebugTarget((IDebugTarget)target);
        }
    }

    private String getPassword(ILaunchConfiguration configuration) {
        String s = SecureStorageUtil.getFromSecureStorage(Activator.getBundleID(), configuration, "org.fusesource.ide.launcher.debug.jmx.passwd");
        return s != null ? s : "";
    }

    protected void setGoals(String newGoals) {
        this.goals = newGoals;
    }

    protected void setSkipTests(boolean skipTests) {
        this.skipTests = skipTests;
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        StringBuilder sb = new StringBuilder();
        sb.append(" ").append(super.getVMArguments(configuration));
        sb.append(" -DECLIPSE_PROCESS_NAME=\"'" + this.getEclipseProcessName() + "'\"");
        sb.append(" -Dmaven.test.skip=" + this.skipTests);
        sb.append(" -Dorg.apache.camel.jmx.createRmiConnector=True");
        return sb.toString();
    }

    public abstract String getEclipseProcessName();
}

