/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.launcher.run.util;

import org.apache.maven.model.Model;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.launcher.Activator;

public class MavenLaunchUtils {
    public static String substituteVar(String s) {
        if (s == null) {
            return s;
        }
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
        }
        catch (CoreException e) {
            Activator.getLogger().error("Could not substitute variable {}.", (Throwable)e);
            return null;
        }
    }

    public static boolean isPackagingTypeWAR(String pathToPomXML) throws CoreException {
        return MavenLaunchUtils.isPackagingTypeWAR(ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)pathToPomXML)));
    }

    public static boolean isPackagingTypeWAR(IFile pomFile) throws CoreException {
        if (pomFile == null || !pomFile.exists()) {
            throw new CoreException((IStatus)new Status(4, Activator.getBundleID(), "Can't determine packaging type because given pom file reference is null!"));
        }
        Model model = MavenPlugin.getMavenModelManager().readMavenModel(pomFile);
        return "war".equalsIgnoreCase(model.getPackaging());
    }
}

