/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.tools.textimport.ui.wizards;

import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.tools.textimport.ui.wizards.IRowObject;

public abstract class AbstractRowObject
implements IRowObject {
    private static final StringNameValidator nameValidator = new StringNameValidator();
    private String rawString;
    private String dataString;
    private String name;
    private String location;
    private String description;
    public int type;
    private boolean valid = false;

    public AbstractRowObject(String row) {
        this.dataString = row;
    }

    @Override
    public abstract void parseRow();

    protected String parseDescription(String subString) {
        StringBuffer buffer = new StringBuffer();
        boolean removedFirstDQuote = false;
        boolean addChar = false;
        int length = subString.length();
        int i = 0;
        while (i < length) {
            if (i < length - 2 && subString.charAt(i) == '\"') {
                if (removedFirstDQuote) {
                    addChar = subString.charAt(i + 1) != '\"';
                } else {
                    removedFirstDQuote = true;
                }
            } else {
                addChar = subString.charAt(i) != '\"' || i != length - 1;
            }
            if (addChar) {
                buffer.append(subString.charAt(i));
            }
            ++i;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Relational Row Object").append("\n    Name               = " + this.name).append("\n    Description        = " + this.description);
        return buffer.toString();
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String desc) {
        this.description = desc;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = this.createValidName(name, true);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @Override
    public int getObjectType() {
        return this.type;
    }

    public void setObjectType(int type) {
        this.type = type;
    }

    @Override
    public String getDataString() {
        return this.dataString;
    }

    @Override
    public String getRawString() {
        return this.rawString;
    }

    @Override
    public void setRawString(String rawString) {
        this.rawString = rawString;
    }

    public String createValidName(String input, boolean performValidityCheck) {
        String validName = nameValidator.createValidName(input, performValidityCheck);
        if (validName != null) {
            return validName;
        }
        return input;
    }
}

