/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.core.xslt;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import org.teiid.core.designer.TeiidDesignerException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.xslt.CoreXsltPlugin;
import org.teiid.designer.core.xslt.Style;

public class StyleFromUrlStream
implements Style {
    private final String name;
    private final String description;
    private final String xsltUrl;

    public StyleFromUrlStream(String name, String xsltUri) {
        this(name, xsltUri, null);
    }

    public StyleFromUrlStream(String name, String xsltUri, String desc) {
        CoreArgCheck.isNotNull((Object)name);
        CoreArgCheck.isNotZeroLength((String)name);
        CoreArgCheck.isNotNull((Object)xsltUri);
        CoreArgCheck.isNotZeroLength((String)xsltUri);
        CoreArgCheck.isNotNull((Object)xsltUri);
        this.name = name;
        this.xsltUrl = xsltUri;
        this.description = desc != null ? desc : "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String getXsltUrl() {
        return this.xsltUrl;
    }

    @Override
    public InputStream getInputStream() throws IOException, TeiidDesignerException {
        String xsltURL = this.getXsltUrl();
        URL url = new URL(this.xsltUrl);
        InputStream stylesheetStream = url.openStream();
        if (stylesheetStream == null) {
            stylesheetStream = new FileInputStream(xsltURL);
        }
        if (stylesheetStream.available() == 0) {
            Object[] params = new Object[]{xsltURL};
            String msg = CoreXsltPlugin.Util.getString("StyleFromUrlStream.empty_xslt", params);
            throw new TeiidDesignerException(msg);
        }
        return stylesheetStream;
    }

    @Override
    public StreamSource getStreamSource() throws IOException, TeiidDesignerException {
        InputStream stream = this.getInputStream();
        return new StreamSource(stream);
    }
}

