/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.wst.wsdl.validation.internal.IValidationMessage;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.eclipse.URIResolverWrapper;
import org.eclipse.wst.wsdl.validation.internal.resolver.IExtensibleURIResolver;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.modelgenerator.wsdl.ModelGeneratorWsdlPlugin;
import org.teiid.designer.modelgenerator.wsdl.model.Model;
import org.teiid.designer.modelgenerator.wsdl.model.ModelGenerationException;
import org.teiid.designer.modelgenerator.wsdl.model.impl.ModelBuilder;
import org.teiid.designer.modelgenerator.wsdl.validation.WSDLValidationException;
import org.teiid.designer.modelgenerator.wsdl.validation.WSDLValidationMessage;
import org.teiid.designer.ui.common.ICredentialsCommon;

public class WSDLReader {
    private String wsdlURI;
    private ICredentialsCommon.SecurityType securityType = ICredentialsCommon.SecurityType.None;
    private String userName;
    private String password;
    private static WSDLValidator VALIDATOR;
    public static final int VALIDATION_SEVERITY_ERROR = 0;
    public static final int VALIDATION_SEVERITY_WARNING = 1;

    public WSDLReader() {
        this(null);
    }

    public WSDLReader(String fileUri) {
        this.wsdlURI = fileUri;
    }

    public Model getModel() throws ModelGenerationException {
        Model theModel = null;
        try {
            theModel = this.buildWSDLStructures();
        }
        catch (NullPointerException ex) {
            ModelGeneratorWsdlPlugin.Util.log(4, (Throwable)ex, this.getString("WSDLReader.unexpected.parsing.wsdl"));
            Exception e = new Exception(this.getString("WSDLReader.unexpected.parsing.wsdl"));
            throw new ModelGenerationException(e);
        }
        catch (Exception ex) {
            throw new ModelGenerationException(ex);
        }
        return theModel;
    }

    private Model buildWSDLStructures() throws Exception {
        if (this.wsdlURI == null) {
            throw new Exception(this.getString("WSDLReader.unexpected.parsing.wsdl"));
        }
        ModelBuilder builder = new ModelBuilder();
        builder.setAuthentication(this.securityType, this.userName, this.password);
        builder.setWSDL(this.wsdlURI.replace("%20", " "));
        if (!builder.isWSDLParsed()) {
            Exception myEx = builder.getWSDLException();
            throw myEx;
        }
        return builder.getModel();
    }

    public String getWSDLUri() {
        return this.wsdlURI;
    }

    public void setAuthenticationCredentials(ICredentialsCommon.SecurityType securityType, String userName, String password) {
        this.securityType = securityType;
        this.userName = userName;
        this.password = password;
    }

    public void setWSDLUri(String fileUri) {
        this.wsdlURI = fileUri;
    }

    /*
     * Unable to fully structure code
     */
    public MultiStatus validateWSDL(IProgressMonitor monitor) {
        block30: {
            block31: {
                block28: {
                    block29: {
                        monitor.beginTask(this.getString("WSDLReader.validating.wsdl"), -1);
                        monitor.worked(1);
                        if (WSDLReader.VALIDATOR == null) {
                            WSDLReader.VALIDATOR = new WSDLValidator();
                            WSDLReader.VALIDATOR.addURIResolver((IExtensibleURIResolver)new URIResolverWrapper());
                        }
                        wsdlUri = this.getWSDLUri();
                        messages = new ArrayList<WSDLValidationMessage>();
                        urlConn = null;
                        inputStream = null;
                        remoteURL = URLHelper.buildURL((String)wsdlUri);
                        monitor.worked(1);
                        remoteURL = new URL(wsdlUri);
                        urlConn = remoteURL.openConnection();
                        if (this.securityType != null && !ICredentialsCommon.SecurityType.None.equals((Object)this.securityType)) {
                            URLHelper.setCredentials((URLConnection)urlConn, (String)this.userName, (String)this.password);
                        }
                        inputStream = urlConn.getInputStream();
                        report = WSDLReader.VALIDATOR.validate(wsdlUri, inputStream, null);
                        monitor.worked(1);
                        v0 = success = report.hasErrors() == false && report.isWSDLValid() != false;
                        if (!success) break block28;
                        code = 100;
                        monitor.worked(1);
                        monitor.done();
                        var18_17 = status = this.buildStatus(code, null, this.getString("WSDLReader.validation.passed"), null);
                        if (inputStream == null) break block29;
                        try {
                            inputStream.close();
                        }
                        catch (IOException ex) {
                            code = 500;
                            msgProperty = "WSDLReader.close.connection.error";
                            messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                            status = this.buildStatus(code, messages, this.getString(msgProperty), ex);
                        }
                    }
                    return var18_17;
                }
                warningsOnly = report.isWSDLValid();
                code = 500;
                vmessages = report.getValidationMessages();
                i = 0;
                while (i < vmessages.length) {
                    message = this.buildValidationMessageString(vmessages[i]);
                    severity = vmessages[i].getSeverity();
                    if (severity == 0) {
                        warningsOnly = false;
                    }
                    newSeverity = severity == 0 ? 4 : 2;
                    messages.add(new WSDLValidationMessage(message, newSeverity));
                    ++i;
                }
                if (!warningsOnly) break block30;
                monitor.worked(1);
                monitor.done();
                var18_18 = status = this.buildStatus(code, messages, this.getString("WSDLReader.validation.warning"), null);
                if (inputStream == null) break block31;
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    code = 500;
                    msgProperty = "WSDLReader.close.connection.error";
                    messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                    status = this.buildStatus(code, messages, this.getString(msgProperty), ex);
                }
            }
            return var18_18;
        }
        try {
            try {
                contentType = urlConn.getContentType();
                if (messages.size() == 0) {
                    invalidMsgProperty = "WSDLReader.wsdl.invalid";
                    if (!(contentType == null || contentType.contains("text/xml") && contentType.contains("application/xml"))) {
                        messageSuffix = MessageFormat.format(this.getString("WSDLReader.validation.content.type.error"), new Object[]{wsdlUri, contentType});
                        fullMessage = String.valueOf(this.getString(invalidMsgProperty)) + messageSuffix;
                        messages.add(new WSDLValidationMessage(fullMessage, 4));
                        status = this.buildStatus(code, messages, fullMessage, new WSDLValidationException());
                    } else {
                        messages.add(new WSDLValidationMessage(this.getString(invalidMsgProperty), 4));
                        status = this.buildStatus(code, messages, this.getString(invalidMsgProperty), new WSDLValidationException());
                    }
                } else {
                    validationErrorProperty = "WSDLReader.validation.error";
                    if (!remoteURL.getProtocol().equals("file") && !contentType.contains("text/xml") || !contentType.equals("application/xml")) {
                        messageSuffix = MessageFormat.format(this.getString("WSDLReader.validation.content.type.error"), new Object[]{wsdlUri, contentType});
                        status = this.buildStatus(code, messages, String.valueOf(this.getString(validationErrorProperty)) + messageSuffix, new WSDLValidationException());
                    } else {
                        status = this.buildStatus(code, messages, this.getString(validationErrorProperty), new WSDLValidationException());
                    }
                }
            }
            catch (Exception e) {
                code = 500;
                msgProperty = "WSDLReader.open.connection.error";
                messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                status = this.buildStatus(code, messages, this.getString(msgProperty), e);
                if (inputStream == null) ** GOTO lbl134
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    code = 500;
                    msgProperty = "WSDLReader.close.connection.error";
                    messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                    status = this.buildStatus(code, messages, this.getString(msgProperty), ex);
                }
            }
        }
        catch (Throwable var17_39) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {
                    code = 500;
                    msgProperty = "WSDLReader.close.connection.error";
                    messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                    status = this.buildStatus(code, messages, this.getString(msgProperty), ex);
                }
            }
            throw var17_39;
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException ex) {
                code = 500;
                msgProperty = "WSDLReader.close.connection.error";
                messages.add(new WSDLValidationMessage(this.getString(msgProperty), 4));
                status = this.buildStatus(code, messages, this.getString(msgProperty), ex);
            }
        }
lbl134:
        // 7 sources

        monitor.worked(1);
        monitor.done();
        return status;
    }

    private MultiStatus buildStatus(int code, List<? extends IStatus> childMessages, String message, Exception exception) {
        return new MultiStatus("org.teiid.modelgenerator.wsdl", code, childMessages == null ? new IStatus[]{} : childMessages.toArray(new IStatus[0]), message, (Throwable)exception);
    }

    private String getString(String property) {
        return ModelGeneratorWsdlPlugin.Util.getString(property, new Object[0]);
    }

    private String buildValidationMessageString(IValidationMessage vmessage) {
        StringBuffer buff = new StringBuffer();
        buff.append(vmessage.getLine());
        buff.append(":");
        buff.append(vmessage.getColumn());
        buff.append(" - ");
        buff.append(vmessage.getMessage());
        return buff.toString();
    }
}

