/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.model.impl;

import org.teiid.designer.modelgenerator.wsdl.model.Binding;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.Port;
import org.teiid.designer.modelgenerator.wsdl.model.impl.WSDLElementImpl;

public class BindingImpl
extends WSDLElementImpl
implements Binding {
    private Port m_port;
    private Operation[] m_operations;
    private String m_transportURI;
    private String m_style;

    public BindingImpl(Port port) {
        this.m_port = port;
    }

    @Override
    public Operation[] getOperations() {
        int arrayLength = this.m_operations.length;
        Operation[] ops = new Operation[arrayLength];
        int i = 0;
        while (i < arrayLength) {
            ops[i] = this.m_operations[i].copy();
            ++i;
        }
        return ops;
    }

    @Override
    public Port getPort() {
        return this.m_port;
    }

    @Override
    public void setOperations(Operation[] operations) {
        this.m_operations = operations;
    }

    @Override
    public Binding copy() {
        BindingImpl theBinding = new BindingImpl(this.m_port);
        theBinding.setName(this.getName());
        theBinding.setId(this.getId());
        theBinding.setStyle(this.getStyle());
        theBinding.setOperations(this.getOperations());
        return theBinding;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("<binding name='");
        buff.append(this.getName());
        buff.append("' id='");
        buff.append(this.getId());
        buff.append("'>");
        int i = 0;
        while (i < this.m_operations.length) {
            buff.append(this.m_operations[i].toString());
            ++i;
        }
        buff.append("</binding>");
        return buff.toString();
    }

    @Override
    public void setTransportURI(String uri) {
        this.m_transportURI = uri;
    }

    public String getTransportURI() {
        return this.m_transportURI;
    }

    @Override
    public void setStyle(String style) {
        this.m_style = style;
    }

    public String getStyle() {
        return this.m_style;
    }
}

