/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.wsdl.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.teiid.designer.modelgenerator.wsdl.SoapBindingInfo;
import org.teiid.designer.modelgenerator.wsdl.model.Binding;
import org.teiid.designer.modelgenerator.wsdl.model.Fault;
import org.teiid.designer.modelgenerator.wsdl.model.Message;
import org.teiid.designer.modelgenerator.wsdl.model.Operation;
import org.teiid.designer.modelgenerator.wsdl.model.impl.WSDLElementImpl;

public class OperationImpl
extends WSDLElementImpl
implements Operation {
    private Binding m_binding;
    private Message m_input;
    private Message m_output;
    private String m_style;
    private Fault[] m_faults;
    private String m_soapAction;
    private boolean m_canModel;
    private ArrayList m_messages;
    private SoapBindingInfo m_bindingInfo;

    public OperationImpl(Binding binding) {
        this.m_binding = binding;
        this.m_faults = new Fault[0];
        this.m_canModel = true;
        this.m_messages = new ArrayList();
    }

    @Override
    public Binding getBinding() {
        return this.m_binding;
    }

    @Override
    public Operation copy() {
        OperationImpl oper = new OperationImpl(this.getBinding());
        oper.setName(this.getName());
        oper.setId(this.getId());
        oper.setStyle(this.getStyle());
        oper.setCanModel(this.canModel());
        oper.setSOAPAction(this.getSOAPAction());
        Iterator iter = this.m_messages.iterator();
        while (iter.hasNext()) {
            oper.addProblemMessage((String)iter.next());
        }
        if (this.m_input != null) {
            oper.setInputMessage(this.m_input.copy());
        }
        if (this.m_output != null) {
            oper.setOutputMessage(this.m_output.copy());
        }
        Fault[] newFaults = new Fault[this.m_faults.length];
        int i = 0;
        while (i < this.m_faults.length) {
            newFaults[i] = this.m_faults[i].copy();
            ++i;
        }
        oper.setFaults(newFaults);
        return oper;
    }

    public String toString() {
        Fault[] faults;
        StringBuffer buff = new StringBuffer();
        buff.append("<operation name='");
        buff.append(this.getName());
        buff.append("' id='");
        buff.append(this.getId());
        buff.append("' style='");
        buff.append(this.getStyle());
        buff.append("' soapAction='");
        buff.append(this.getSOAPAction());
        buff.append("' canModel='");
        buff.append(this.canModel());
        buff.append("'>");
        if (this.getInputMessage() != null) {
            buff.append(this.getInputMessage().toString());
        }
        if (this.getOutputMessage() != null) {
            buff.append(this.getOutputMessage().toString());
        }
        if ((faults = this.getFaults()) != null) {
            int i = 0;
            while (i < faults.length) {
                buff.append(faults[i].toString());
                ++i;
            }
        }
        buff.append("</operation>");
        return buff.toString();
    }

    @Override
    public Message getInputMessage() {
        return this.m_input;
    }

    @Override
    public void setInputMessage(Message inputMsg) {
        this.m_input = inputMsg;
    }

    @Override
    public Message getOutputMessage() {
        return this.m_output;
    }

    @Override
    public void setOutputMessage(Message outputMsg) {
        this.m_output = outputMsg;
    }

    public String getStyle() {
        return this.m_style;
    }

    @Override
    public void setStyle(String style) {
        this.m_style = style;
    }

    @Override
    public Fault[] getFaults() {
        return this.m_faults;
    }

    @Override
    public void setFaults(Fault[] faults) {
        this.m_faults = faults;
    }

    @Override
    public void setSOAPAction(String action) {
        this.m_soapAction = action;
    }

    public String getSOAPAction() {
        return this.m_soapAction;
    }

    public boolean canModel() {
        return this.m_canModel;
    }

    @Override
    public void setCanModel(boolean canModel) {
        this.m_canModel = canModel;
    }

    @Override
    public void addProblemMessage(String message) {
        this.m_messages.add(message);
    }

    public String[] getProblemMessages() {
        String[] retVal = new String[this.m_messages.size()];
        this.m_messages.toArray(retVal);
        return retVal;
    }

    @Override
    public SoapBindingInfo getSoapBindingInfo() {
        return this.m_bindingInfo;
    }

    @Override
    public void setSoapBindingInfo(SoapBindingInfo info) {
        this.m_bindingInfo = info;
    }
}

