/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveFactory;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.util.IModelerPerspectiveContributor;
import org.teiid.designer.ui.util.PerspectiveObject;

public class ModelerPerspectiveFactory
implements UiConstants.Extensions,
IPerspectiveFactory,
UiConstants.ExtensionPoints.ModelerPerspectiveContributorExtension {
    private static List<IModelerPerspectiveContributor> contributors;
    private static PerspectiveObject[] contributedPOs;

    public ModelerPerspectiveFactory() {
        ModelerPerspectiveFactory.loadPerpectiveExtensions();
    }

    private void addView(String theViewId, IFolderLayout theFolder, IPageLayout thePage) {
        theFolder.addView(theViewId);
        thePage.addShowViewShortcut(theViewId);
    }

    public void createInitialLayout(IPageLayout theLayout) {
        theLayout.addPerspectiveShortcut("modelerPerspective");
        String editorArea = theLayout.getEditorArea();
        IFolderLayout topLeftFolder = theLayout.createFolder(TREE_FOLDER, 1, 0.25f, editorArea);
        this.addView("explorer.view", topLeftFolder, theLayout);
        this.addView("org.eclipse.ui.views.ContentOutline", topLeftFolder, theLayout);
        this.addView("org.eclipse.ui.navigator.ProjectExplorer", topLeftFolder, theLayout);
        topLeftFolder.addPlaceholder("views.datatypeHierarchyView");
        topLeftFolder.addPlaceholder("views.metamodelsView");
        PerspectiveObject po2 = null;
        Collection<PerspectiveObject> otherViews = this.getViews(0, false);
        if (!otherViews.isEmpty()) {
            for (PerspectiveObject po2 : otherViews) {
                if (po2.isPlaceholder()) {
                    topLeftFolder.addPlaceholder(po2.getViewId());
                    continue;
                }
                this.addView(po2.getViewId(), topLeftFolder, theLayout);
            }
        }
        IFolderLayout bottomRightFolder = theLayout.createFolder(OUTPUT_FOLDER, 4, 0.75f, editorArea);
        this.addView("org.eclipse.ui.views.ProblemView", bottomRightFolder, theLayout);
        this.addView("org.eclipse.pde.runtime.LogView", bottomRightFolder, theLayout);
        bottomRightFolder.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        otherViews = this.getViews(2, false);
        if (!otherViews.isEmpty()) {
            for (PerspectiveObject po2 : otherViews) {
                if (po2.isPlaceholder()) {
                    bottomRightFolder.addPlaceholder(po2.getViewId());
                    continue;
                }
                this.addView(po2.getViewId(), bottomRightFolder, theLayout);
            }
        }
        theLayout.addShowViewShortcut("org.eclipse.search.ui.views.SearchView");
        IFolderLayout bottomLeftFolder = theLayout.createFolder(PROPERTY_FOLDER, 4, 0.65f, TREE_FOLDER);
        this.addView("org.eclipse.ui.views.PropertySheet", bottomLeftFolder, theLayout);
        this.addView("views.descriptionView", bottomLeftFolder, theLayout);
        bottomLeftFolder.addPlaceholder("views.tagsView");
        otherViews = this.getViews(1, false);
        if (!otherViews.isEmpty()) {
            for (PerspectiveObject po2 : otherViews) {
                if (po2.isPlaceholder()) {
                    bottomLeftFolder.addPlaceholder(po2.getViewId());
                    continue;
                }
                this.addView(po2.getViewId(), bottomLeftFolder, theLayout);
            }
        }
        if ((otherViews = this.getViews(4, false)) != null && !otherViews.isEmpty()) {
            IFolderLayout centerLeftFolder = theLayout.createFolder(CENTER_LEFT_FOLDER, 3, 0.4f, PROPERTY_FOLDER);
            for (PerspectiveObject po2 : otherViews) {
                if (po2.isPlaceholder()) {
                    centerLeftFolder.addPlaceholder(po2.getViewId());
                    continue;
                }
                this.addView(po2.getViewId(), centerLeftFolder, theLayout);
            }
        }
        if ((otherViews = this.getViews(3, false)) != null && !otherViews.isEmpty()) {
            IFolderLayout topRightFolder = theLayout.createFolder(TOP_RIGHT_FOLDER, 2, 0.65f, editorArea);
            for (PerspectiveObject po2 : otherViews) {
                if (po2.isPlaceholder()) {
                    topRightFolder.addPlaceholder(po2.getViewId());
                    continue;
                }
                this.addView(po2.getViewId(), topRightFolder, theLayout);
            }
        }
        theLayout.addNewWizardShortcut("newModelProject");
        theLayout.addNewWizardShortcut("org.eclipse.ui.wizards.new.folder");
        theLayout.addNewWizardShortcut("newModel");
        theLayout.addNewWizardShortcut("newVdbWizard");
        theLayout.addNewWizardShortcut("newMedWizard");
    }

    private static void loadPerspectiveObjects() {
        int i;
        ArrayList<PerspectiveObject> poList = new ArrayList<PerspectiveObject>();
        boolean oK = true;
        Iterator<IModelerPerspectiveContributor> iter = contributors.iterator();
        IModelerPerspectiveContributor helper = null;
        while (iter.hasNext() && oK) {
            helper = iter.next();
            PerspectiveObject[] contributions = helper.getContributions();
            i = 0;
            while (i < contributions.length) {
                poList.add(contributions[i]);
                ++i;
            }
        }
        contributedPOs = new PerspectiveObject[poList.size()];
        if (!poList.isEmpty()) {
            Iterator iter2 = poList.iterator();
            i = 0;
            while (iter2.hasNext()) {
                ModelerPerspectiveFactory.contributedPOs[i++] = (PerspectiveObject)iter2.next();
            }
        }
    }

    private Collection<PerspectiveObject> getViews(int viewLocationId, boolean isPrimary) {
        if (contributedPOs.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<PerspectiveObject> views = new ArrayList<PerspectiveObject>();
        int i = 0;
        while (i < contributedPOs.length) {
            if (ModelerPerspectiveFactory.contributedPOs[i].locationID == viewLocationId) {
                views.add(contributedPOs[i]);
            }
            ++i;
        }
        if (views.isEmpty()) {
            return Collections.emptyList();
        }
        return views;
    }

    private static void loadPerpectiveExtensions() {
        contributors = new ArrayList<IModelerPerspectiveContributor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.teiid.designer.ui", "modelerPerspectiveContributor");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            try {
                int j = 0;
                while (j < elements.length) {
                    Object contributor;
                    if (elements[j].getName().equals("class") && (contributor = elements[j].createExecutableExtension("name")) instanceof IModelerPerspectiveContributor) {
                        contributors.add((IModelerPerspectiveContributor)contributor);
                    }
                    ++j;
                }
            }
            catch (Exception e) {
                String message = UiConstants.Util.getString("ModelerPerspectiveFactory.loadingExtensionsErrorMessage", (Object)extensions[i].getUniqueIdentifier());
                UiConstants.Util.log(4, (Throwable)e, message);
            }
            ++i;
        }
        ModelerPerspectiveFactory.loadPerspectiveObjects();
    }
}

