/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    private Image baseImage;
    private Point sizeOfImage;
    private ImageData overlayImageData;
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private static int LOCATION = 3;

    public OverlayImageIcon(Image baseImage, Image demoImage) {
        this.baseImage = baseImage;
        this.overlayImageData = demoImage.getImageData();
        this.sizeOfImage = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    public OverlayImageIcon(Image baseImage, Image demoImage, int location) {
        LOCATION = location;
        this.baseImage = baseImage;
        this.overlayImageData = demoImage.getImageData();
        this.sizeOfImage = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        ImageData imageData = this.overlayImageData;
        if (imageData != null) {
            switch (LOCATION) {
                case 0: {
                    this.drawImage(imageData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(imageData, this.sizeOfImage.x - imageData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(imageData, 0, this.sizeOfImage.y - imageData.height);
                    break;
                }
                case 3: {
                    this.drawImage(imageData, this.sizeOfImage.x - imageData.width, this.sizeOfImage.y - imageData.height);
                }
            }
        }
    }

    protected Point getSize() {
        return this.sizeOfImage;
    }

    public Image getImage() {
        return this.createImage();
    }
}

