/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.AbstractUiPlugin;
import org.teiid.designer.ui.common.actions.AbstractAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class BookmarkAction
extends AbstractAction
implements UiConstants {
    boolean promptForName = true;

    public BookmarkAction() {
        super((AbstractUiPlugin)UiPlugin.getDefault());
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        super.selectionChanged(thePart, theSelection);
        this.setEnabled(!this.isEmptySelection());
    }

    void createMarker(String markerType) {
        List selectedResources = SelectionUtilities.getSelectedObjects((ISelection)this.getSelection());
        for (Object o : selectedResources) {
            if (o instanceof IFile) {
                this.createMarker((IFile)o, markerType);
                continue;
            }
            if (o instanceof IAdaptable) {
                Object resource = ((IAdaptable)o).getAdapter(IResource.class);
                if (!(resource instanceof IFile)) continue;
                this.createMarker((IFile)resource, markerType);
                continue;
            }
            if (!(o instanceof EObject)) continue;
            EObject eObj = (EObject)o;
            ModelResource mr = ModelUtilities.getModelResourceForModelObject(eObj);
            this.createEObjectMarker(mr.getResource(), eObj);
        }
    }

    void createMarker(final IFile file, final String markerType) {
        try {
            file.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    String markerMessage = file.getName();
                    if (BookmarkAction.this.promptForName) {
                        markerMessage = BookmarkAction.this.askForLabel(markerMessage);
                    }
                    if (markerMessage != null) {
                        IMarker marker = file.createMarker(markerType);
                        marker.setAttribute("message", (Object)markerMessage);
                    }
                }
            }, null);
        }
        catch (CoreException e) {
            Util.log(e.getStatus());
        }
    }

    private void createEObjectMarker(IResource resource, EObject eObject) {
        try {
            String markerMessage = null;
            if (this.promptForName) {
                markerMessage = this.askForLabel(markerMessage);
            }
            if (markerMessage != null) {
                IMarker marker = resource.createMarker("org.eclipse.core.resources.bookmark");
                String targetURI = ModelerCore.getModelEditor().getUri(eObject).toString();
                marker.setAttribute("org.teiid.designer.core.markerURI", (Object)targetURI);
                marker.setAttribute("org.teiid.designer.core.targetMarkerURI", (Object)targetURI);
                marker.setAttribute("message", (Object)markerMessage);
            }
        }
        catch (CoreException e) {
            Util.log(e.getStatus());
        }
    }

    protected void doRun() {
        this.createMarker("org.eclipse.core.resources.bookmark");
    }

    String askForLabel(String proposal) {
        String title = UiConstants.Util.getString("AddBookmarkDialog.title", new Object[0]);
        String message = UiConstants.Util.getString("AddBookmarkDialog.message", new Object[0]);
        IInputValidator inputValidator = new IInputValidator(){

            public String isValid(String newText) {
                return newText == null || newText.length() == 0 ? " " : null;
            }
        };
        Shell shell = UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
        InputDialog dialog = new InputDialog(shell, title, message, proposal, inputValidator);
        if (dialog.open() != 1) {
            String name = dialog.getValue();
            if (name == null) {
                return null;
            }
            return (name = name.trim()).length() == 0 ? null : name;
        }
        return null;
    }
}

