/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.refactor.ModelResourceCollectorVisitor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.core.workspace.WorkspaceResourceFinderUtil;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.ModelResourceEvent;

public class BuildImportsAllAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private Collection<ModelResource> getModelResourceList() {
        ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
        WorkspaceResourceFinderUtil.getProjectFileResources((IResourceVisitor)visitor);
        try {
            return visitor.getModelResources();
        }
        catch (CoreException e) {
            UiConstants.Util.log((Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }

    public void init(IViewPart view) {
    }

    public void init(IWorkbenchWindow window) {
    }

    void rebuildImports(IProgressMonitor theMonitor) {
        String message;
        String title;
        ArrayList<ModelResource> eventList = new ArrayList<ModelResource>();
        ArrayList<ModelResource> modelsToSave = new ArrayList<ModelResource>();
        final ArrayList<String> readOnlyModels = new ArrayList<String>();
        final ArrayList<IFile> errorModels = new ArrayList<IFile>();
        int size = this.getModelResourceList().size() + 1;
        theMonitor.beginTask(UiConstants.Util.getString("RebuildImportsAllAction.rebuildAllModels", new Object[0]), size);
        int count = 0;
        Iterator<Object> iter = this.getModelResourceList().iterator();
        while (iter.hasNext()) {
            ++count;
            try {
                theMonitor.setTaskName(UiConstants.Util.getString("RebuildImportsAllAction.progressMessage", new Object[]{new Integer(count), new Integer(size - 1)}));
                ModelResource modelResource = (ModelResource)iter.next();
                if (modelResource == null) continue;
                if (!modelResource.isReadOnly()) {
                    IFile modelFile = (IFile)modelResource.getResource();
                    boolean succeeded = false;
                    try {
                        succeeded = ModelBuildUtil.rebuildImports((Resource)modelResource.getEmfResource(), (boolean)true);
                    }
                    catch (ModelWorkspaceException theException) {
                        UiConstants.Util.log(4, (Throwable)theException, theException.getMessage());
                    }
                    if (succeeded) {
                        eventList.add(modelResource);
                    } else {
                        errorModels.add(modelFile);
                    }
                    if (ModelEditorManager.isOpen(modelFile)) continue;
                    modelsToSave.add(modelResource);
                    continue;
                }
                readOnlyModels.add(modelResource.getPath().makeRelative().toString());
            }
            finally {
                theMonitor.worked(1);
            }
        }
        theMonitor.setTaskName(UiConstants.Util.getString("RebuildImportsAllAction.savingMessage", new Object[]{new Integer(count), new Integer(size - 1)}));
        iter = modelsToSave.iterator();
        while (iter.hasNext()) {
            try {
                ((ModelResource)iter.next()).save(null, true);
            }
            catch (ModelWorkspaceException e) {
                UiConstants.Util.log(4, (Throwable)e, e.getMessage());
            }
        }
        iter = eventList.iterator();
        while (iter.hasNext()) {
            ModelResourceEvent event = new ModelResourceEvent((ModelResource)iter.next(), 5, (Object)this);
            UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
        }
        if (!readOnlyModels.isEmpty()) {
            title = UiConstants.Util.getString("RebuildImports.readOnlyTitle", new Object[0]);
            message = UiConstants.Util.getString("RebuildImports.readOnlyMessage", new Object[0]);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ListMessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, null, (String)message, (List)readOnlyModels, null);
                }
            });
        }
        theMonitor.worked(1);
        if (!errorModels.isEmpty()) {
            title = UiConstants.Util.getString("RebuildImports.errorTitle", new Object[0]);
            message = UiConstants.Util.getString("RebuildImports.errorMessage", new Object[0]);
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ListMessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)title, null, (String)message, (List)errorModels, null);
                }
            });
        }
    }

    public void run(IAction action) {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor theMonitor) {
                block14: {
                    boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Rebuild All Imports", (Object)((Object)this));
                    boolean succeeded = false;
                    try {
                        try {
                            BuildImportsAllAction.this.rebuildImports(theMonitor);
                            succeeded = true;
                        }
                        catch (Exception err) {
                            String msg = UiConstants.Util.getString("RebuildImportsAllAction.errorMessage", new Object[0]);
                            UiConstants.Util.log(4, (Throwable)err, msg);
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        throw throwable;
                    }
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
                theMonitor.done();
            }
        };
        try {
            new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            UiConstants.Util.log(e.getTargetException());
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

