/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.builder.ModelBuildUtil;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.event.ModelResourceEvent;
import org.teiid.designer.ui.viewsupport.ModelUtilities;

public class BuildModelImportsAction
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    private List selectedModels;

    public BuildModelImportsAction() {
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/obj16/Imports.gif"));
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    @Override
    public boolean isApplicable(ISelection selection) {
        boolean result = true;
        List selectedObjs = SelectionUtilities.getSelectedObjects((ISelection)selection);
        if (selectedObjs.isEmpty()) {
            result = false;
        }
        if (result) {
            for (Object obj : selectedObjs) {
                if (obj instanceof IFile) {
                    if (!ModelUtilities.isModelFile((IResource)((IFile)obj))) {
                        result = false;
                    }
                } else {
                    result = false;
                }
                if (!result) break;
            }
        }
        return result;
    }

    void rebuildImports() {
        if (this.selectedModels != null) {
            ArrayList<ModelResource> eventList = new ArrayList<ModelResource>();
            ArrayList<ModelResource> modelsToSave = new ArrayList<ModelResource>();
            for (IFile modelFile : this.selectedModels) {
                try {
                    ModelResource modelResource = ModelUtil.getModelResource((IFile)modelFile, (boolean)true);
                    try {
                        ModelBuildUtil.rebuildImports((Resource)modelResource.getEmfResource(), (boolean)true);
                    }
                    catch (ModelWorkspaceException theException) {
                        UiConstants.Util.log(4, (Throwable)theException, theException.getMessage());
                    }
                    eventList.add(modelResource);
                    if (ModelEditorManager.isOpen(modelFile)) continue;
                    modelsToSave.add(modelResource);
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            Iterator iter = modelsToSave.iterator();
            while (iter.hasNext()) {
                try {
                    ((ModelResource)iter.next()).save(null, true);
                }
                catch (ModelWorkspaceException e) {
                    UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                }
            }
            iter = eventList.iterator();
            while (iter.hasNext()) {
                ModelResourceEvent event = new ModelResourceEvent((ModelResource)iter.next(), 5, (Object)this);
                UiPlugin.getDefault().getEventBroker().processEvent((EventObject)event);
            }
        }
    }

    public void run() {
        if (this.selectedModels != null) {
            WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor theMonitor) {
                    block14: {
                        boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Rebuild All Imports", (Object)((Object)this));
                        boolean succeeded = false;
                        try {
                            try {
                                BuildModelImportsAction.this.rebuildImports();
                                succeeded = true;
                            }
                            catch (Exception err) {
                                String msg = UiConstants.Util.getString("RebuildImportsAllAction.errorMessage", new Object[0]);
                                UiConstants.Util.log(4, (Throwable)err, msg);
                                if (started) {
                                    if (succeeded) {
                                        ModelerCore.commitTxn();
                                    } else {
                                        ModelerCore.rollbackTxn();
                                    }
                                }
                                break block14;
                            }
                        }
                        catch (Throwable throwable) {
                            if (started) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            throw throwable;
                        }
                        if (started) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                    theMonitor.done();
                }
            };
            try {
                new ProgressMonitorDialog(Display.getCurrent().getActiveShell()).run(true, true, (IRunnableWithProgress)op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                UiConstants.Util.log(e.getTargetException());
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        this.selectedModels = SelectionUtilities.getSelectedObjects((ISelection)selection);
        boolean enable = true;
        if (this.selectedModels.isEmpty()) {
            enable = false;
        } else {
            for (Object obj : this.selectedModels) {
                if (obj instanceof IFile) {
                    if (!ModelUtilities.isModelFile((IResource)((IFile)obj))) {
                        enable = false;
                        break;
                    }
                    try {
                        ModelResource modelResource = ModelUtil.getModelResource((IFile)((IFile)obj), (boolean)true);
                        if (modelResource != null && !modelResource.isReadOnly()) continue;
                        enable = false;
                        break;
                    }
                    catch (ModelWorkspaceException e) {
                        UiConstants.Util.log(4, (Throwable)e, e.getMessage());
                        continue;
                    }
                }
                enable = false;
                break;
            }
        }
        this.setEnabled(enable);
    }
}

