/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.actions.ClipboardActionHandler;

public class ClipboardActionsAdapter {
    private static final String MENU_CUT = UiConstants.Util.getString("org.teiid.designer.ui.actions.CutAction.text", new Object[0]);
    private static final String MENU_COPY = UiConstants.Util.getString("org.teiid.designer.ui.actions.CopyAction.text", new Object[0]);
    private static final String MENU_PASTE = UiConstants.Util.getString("org.teiid.designer.ui.actions.PasteAction.text", new Object[0]);
    private static final String MENU_DELETE = UiConstants.Util.getString("org.teiid.designer.ui.actions.DeleteAction.text", new Object[0]);
    private static final String MENU_SELECT_ALL = UiConstants.Util.getString("org.teiid.designer.ui.actions.SelectAllAction.text", new Object[0]);
    private final Control ctrl;
    final ClipboardActionHandler clipboardActionHandler;
    MenuItem cut;
    MenuItem copy;
    MenuItem paste;
    MenuItem delete;
    MenuItem selectall;

    public ClipboardActionsAdapter(Control control, ClipboardActionHandler clipHandler) {
        this.ctrl = control;
        this.clipboardActionHandler = clipHandler;
        this.initContextMenu();
        this.clipboardActionHandler.addSelectionChangedListener(new MySelectionChangedListener());
    }

    public Control getControl() {
        return this.ctrl;
    }

    private void initContextMenu() {
        Menu menu = new Menu((Decorations)this.ctrl.getShell(), 8);
        this.ctrl.setMenu(menu);
        this.cut = new MenuItem(menu, 8);
        this.cut.setText(MENU_CUT);
        this.cut.setEnabled(false);
        this.cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardActionsAdapter.this.clipboardActionHandler.cut();
            }
        });
        this.copy = new MenuItem(menu, 8);
        this.copy.setText(MENU_COPY);
        this.copy.setEnabled(false);
        this.copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardActionsAdapter.this.clipboardActionHandler.copy();
            }
        });
        this.paste = new MenuItem(menu, 8);
        this.paste.setText(MENU_PASTE);
        this.paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardActionsAdapter.this.clipboardActionHandler.paste();
            }
        });
        this.delete = new MenuItem(menu, 8);
        this.delete.setText(MENU_DELETE);
        this.delete.setEnabled(false);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardActionsAdapter.this.clipboardActionHandler.delete();
            }
        });
        new MenuItem(menu, 2);
        this.selectall = new MenuItem(menu, 8);
        this.selectall.setText(MENU_SELECT_ALL);
        this.selectall.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ClipboardActionsAdapter.this.clipboardActionHandler.selectAll();
            }
        });
    }

    class MySelectionChangedListener
    implements ISelectionChangedListener {
        MySelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            boolean empty = event.getSelection().isEmpty();
            ClipboardActionsAdapter.this.cut.setEnabled(!empty);
            ClipboardActionsAdapter.this.copy.setEnabled(!empty);
            ClipboardActionsAdapter.this.delete.setEnabled(!empty);
        }
    }
}

