/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.ISelectionAction;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.refactor.SaveModifiedResourcesDialog;
import org.teiid.designer.ui.wizards.CloneProjectWizard;

public class CloneProjectAction2
extends Action
implements ISelectionListener,
Comparable,
ISelectionAction {
    private static final String TITLE = UiConstants.Util.getString("CloneProjectAction2.title", new Object[0]);
    private IProject selectedProject;

    public CloneProjectAction2() {
        this.setText(TITLE);
        this.setToolTipText(TITLE);
        this.setImageDescriptor(UiPlugin.getDefault().getImageDescriptor("icons/full/cview16/clone_project.png"));
        this.setEnabled(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object obj;
        boolean enable = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IProject && ModelerCore.hasModelNature((IProject)((IProject)obj))) {
            this.selectedProject = (IProject)obj;
            enable = true;
        }
        this.setEnabled(enable);
    }

    public int compareTo(Object o) {
        if (o instanceof String) {
            return this.getText().compareTo((String)o);
        }
        if (o instanceof Action) {
            return this.getText().compareTo(((Action)o).getText());
        }
        return 0;
    }

    @Override
    public boolean isApplicable(ISelection selection) {
        Object obj;
        boolean result = false;
        if (!SelectionUtilities.isMultiSelection((ISelection)selection) && (obj = SelectionUtilities.getSelectedObject((ISelection)selection)) instanceof IProject && ModelerCore.hasModelNature((IProject)((IProject)obj))) {
            result = true;
        }
        return result;
    }

    public void run() {
        boolean bContinue = this.doResourceCleanup();
        if (!bContinue) {
            return;
        }
        IWorkbenchWindow iww = UiPlugin.getDefault().getCurrentWorkbenchWindow();
        try {
            CloneProjectWizard wizard = new CloneProjectWizard();
            wizard.setProject(this.selectedProject);
            wizard.init(iww.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.selectedProject));
            WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
            dialog.open();
        }
        catch (Exception e) {
            UiConstants.Util.log(4, (Throwable)e, e.getMessage());
        }
        this.setEnabled(true);
    }

    protected boolean doResourceCleanup() {
        boolean bResult = false;
        if (ModelEditorManager.getDirtyResources().size() > 0) {
            SaveModifiedResourcesDialog pnlSave = new SaveModifiedResourcesDialog(this.getShell());
            pnlSave.open();
            bResult = pnlSave.getReturnCode() == 0;
        } else {
            bResult = true;
        }
        return bResult;
    }

    protected Shell getShell() {
        return UiPlugin.getDefault().getCurrentWorkbenchWindow().getShell();
    }
}

